/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ConsumerRecordConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(IncomingKafkaRecordMetadata.class).isPresent() && target.equals(ConsumerRecord.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        IncomingKafkaRecordMetadata metadata = (IncomingKafkaRecordMetadata)in.getMetadata(IncomingKafkaRecordMetadata.class).orElseThrow(() -> new IllegalStateException("No Kafka metadata"));
        return in.withPayload((Object)metadata.getRecord().getDelegate().record());
    }
}

