/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ClientConfiguration
implements Configuration,
Configurable<ClientConfiguration>,
Providers,
HeaderValueProcessor {
    protected ResteasyProviderFactory providerFactory;

    public ClientConfiguration(ResteasyProviderFactory factory) {
        this.providerFactory = factory instanceof ThreadLocalResteasyProviderFactory ? new LocalResteasyProviderFactory(((ThreadLocalResteasyProviderFactory)factory).getDelegate()) : new LocalResteasyProviderFactory(factory);
    }

    public ClientConfiguration(ClientConfiguration parent) {
        this(parent.getProviderFactory());
        this.setProperties(parent.getProperties());
    }

    public void setProperties(Map<String, Object> newProps) {
        this.providerFactory.setProperties(newProps);
    }

    protected ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public Map<String, Object> getMutableProperties() {
        return this.providerFactory.getMutableProperties();
    }

    public String toHeaderString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return this.providerFactory.toHeaderString(object);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter writer = this.providerFactory.getClientMessageBodyWriter(type, genericType, annotations, mediaType);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        }
        return writer;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyReader reader = this.providerFactory.getClientMessageBodyReader(type, genericType, annotations, mediaType);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
        }
        return reader;
    }

    public WriterInterceptor[] getWriterInterceptors(Class declaring, AccessibleObject target) {
        return (WriterInterceptor[])this.providerFactory.getClientWriterInterceptorRegistry().postMatch(declaring, target);
    }

    public ReaderInterceptor[] getReaderInterceptors(Class declaring, AccessibleObject target) {
        return (ReaderInterceptor[])this.providerFactory.getClientReaderInterceptorRegistry().postMatch(declaring, target);
    }

    public ClientRequestFilter[] getRequestFilters(Class declaring, AccessibleObject target) {
        return (ClientRequestFilter[])this.providerFactory.getClientRequestFilterRegistry().postMatch(declaring, target);
    }

    public ClientResponseFilter[] getResponseFilters(Class declaring, AccessibleObject target) {
        return (ClientResponseFilter[])this.providerFactory.getClientResponseFilters().postMatch(declaring, target);
    }

    public Set<DynamicFeature> getDynamicFeatures() {
        return this.providerFactory.getClientDynamicFeatures();
    }

    public String toString(Object object) {
        return this.providerFactory.toString(object, object.getClass(), null, null);
    }

    public String toString(Object object, Type type, Annotation[] annotations) {
        return this.providerFactory.toString(object, object.getClass(), type, annotations);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.providerFactory.getExceptionMapper(type);
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.providerFactory.getContextResolver(contextType, mediaType);
    }

    public Map<String, Object> getProperties() {
        return this.providerFactory.getProperties();
    }

    public Object getProperty(String name) {
        return this.providerFactory.getProperty(name);
    }

    public Set<Class<?>> getClasses() {
        return this.providerFactory.getClasses();
    }

    public Set<Object> getInstances() {
        return this.providerFactory.getInstances();
    }

    public ClientConfiguration register(Class<?> providerClass) {
        this.providerFactory.register(providerClass);
        return this;
    }

    public ClientConfiguration register(Object provider) {
        this.providerFactory.register(provider);
        return this;
    }

    public ClientConfiguration register(Class<?> providerClass, int priority) {
        this.providerFactory.register(providerClass, priority);
        return this;
    }

    public ClientConfiguration register(Object provider, int Priority) {
        this.providerFactory.register(provider, Priority);
        return this;
    }

    public ClientConfiguration property(String name, Object value) {
        this.providerFactory.property(name, value);
        return this;
    }

    public Configuration getConfiguration() {
        return this;
    }

    public ClientConfiguration register(Class<?> componentClass, Class<?> ... contracts) {
        this.providerFactory.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientConfiguration register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.providerFactory.register(componentClass, contracts);
        return this;
    }

    public ClientConfiguration register(Object component, Class<?> ... contracts) {
        this.providerFactory.register(component, (Class[])contracts);
        return this;
    }

    public ClientConfiguration register(Object component, Map<Class<?>, Integer> contracts) {
        this.providerFactory.register(component, contracts);
        return this;
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.CLIENT;
    }

    public Collection<String> getPropertyNames() {
        return this.providerFactory.getProperties().keySet();
    }

    public boolean isEnabled(Feature feature) {
        return this.providerFactory.isEnabled(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.providerFactory.isEnabled(featureClass);
    }

    public boolean isRegistered(Object component) {
        return this.providerFactory.isRegistered(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.providerFactory.isRegistered(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        return this.providerFactory.getContracts(componentClass);
    }

    public <I extends RxInvoker<?>> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        Map classContracts = this.providerFactory.getClassContracts();
        for (Map.Entry entry : classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!((Map)entry.getValue()).containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.providerFactory.createProviderInstance((Class)entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        return this.providerFactory.getRxInvokerProviderFromReactiveClass(clazz);
    }

    public boolean isReactive(Class<?> clazz) {
        return this.providerFactory.isReactive(clazz);
    }
}

