/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.jstl.fmt;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.jstl.core.Config;
import jakarta.servlet.jsp.jstl.fmt.LocalizationContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

class JakartaInline {
    static final String UNDEFINED_KEY = "???";
    private static final Locale EMPTY_LOCALE = new Locale("", "");
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    static final String REQUEST_CHAR_SET = "jakarta.servlet.jsp.jstl.fmt.request.charset";

    JakartaInline() {
    }

    static LocalizationContext getLocalizationContext(PageContext pc) {
        LocalizationContext locCtxt = null;
        Object obj = Config.find(pc, "jakarta.servlet.jsp.jstl.fmt.localizationContext");
        if (obj == null) {
            return null;
        }
        locCtxt = obj instanceof LocalizationContext ? (LocalizationContext)obj : JakartaInline.getLocalizationContext(pc, (String)obj);
        return locCtxt;
    }

    static LocalizationContext getLocalizationContext(PageContext pc, String basename) {
        LocalizationContext locCtxt = null;
        ResourceBundle bundle = null;
        if (basename == null || basename.equals("")) {
            return new LocalizationContext();
        }
        Locale pref = JakartaInline.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.locale");
        if (pref != null) {
            bundle = JakartaInline.findMatch(basename, pref);
            if (bundle != null) {
                locCtxt = new LocalizationContext(bundle, pref);
            }
        } else {
            locCtxt = JakartaInline.findMatch(pc, basename);
        }
        if (locCtxt == null && (pref = JakartaInline.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (bundle = JakartaInline.findMatch(basename, pref)) != null) {
            locCtxt = new LocalizationContext(bundle, pref);
        }
        if (locCtxt == null) {
            try {
                ClassLoader cl = JakartaInline.getClassLoaderCheckingPrivilege();
                bundle = ResourceBundle.getBundle(basename, EMPTY_LOCALE, cl);
                if (bundle != null) {
                    locCtxt = new LocalizationContext(bundle, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (locCtxt != null) {
            if (locCtxt.getLocale() != null) {
                JakartaInline.setResponseLocale(pc, locCtxt.getLocale());
            }
        } else {
            locCtxt = new LocalizationContext();
        }
        return locCtxt;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String basename) {
        LocalizationContext locCtxt = null;
        Enumeration enum_ = JakartaInline.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enum_.hasMoreElements()) {
            Locale pref = (Locale)enum_.nextElement();
            ResourceBundle match = JakartaInline.findMatch(basename, pref);
            if (match == null) continue;
            locCtxt = new LocalizationContext(match, pref);
            break;
        }
        return locCtxt;
    }

    private static ResourceBundle findMatch(String basename, Locale pref) {
        ResourceBundle match = null;
        try {
            ClassLoader cl = JakartaInline.getClassLoaderCheckingPrivilege();
            ResourceBundle bundle = ResourceBundle.getBundle(basename, pref, cl);
            Locale avail = bundle.getLocale();
            if (pref.equals(avail)) {
                match = bundle;
            } else if (pref.getLanguage().equals(avail.getLanguage()) && ("".equals(avail.getCountry()) || pref.getCountry().equals(avail.getCountry()))) {
                match = bundle;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return match;
    }

    private static ClassLoader getClassLoaderCheckingPrivilege() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader cl = sm == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    public static Enumeration getRequestLocales(HttpServletRequest request) {
        Enumeration values = request.getHeaders("accept-language");
        if (values == null) {
            return new Vector().elements();
        }
        if (values.hasMoreElements()) {
            return request.getLocales();
        }
        return values;
    }

    static void setResponseLocale(PageContext pc, Locale locale) {
        ServletResponse response = pc.getResponse();
        response.setLocale(locale);
        if (pc.getSession() != null) {
            try {
                pc.setAttribute(REQUEST_CHAR_SET, (Object)response.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static Locale getLocale(PageContext pageContext, String name) {
        Locale loc = null;
        Object obj = Config.find(pageContext, name);
        if (obj != null) {
            loc = obj instanceof Locale ? (Locale)obj : JakartaInline.parseLocale((String)obj, null);
        }
        return loc;
    }

    private static Locale parseLocale(String locale, String variant) {
        Locale ret = null;
        String language = locale;
        String country = null;
        int index = -1;
        index = locale.indexOf(45);
        if (index > -1 || (index = locale.indexOf(95)) > -1) {
            language = locale.substring(0, index);
            country = locale.substring(index + 1);
        }
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException("Missing language component in 'value' attribute in &lt;setLocale&gt;");
        }
        if (country == null) {
            ret = variant != null ? new Locale(language, "", variant) : new Locale(language, "");
        } else if (country.length() > 0) {
            ret = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
        } else {
            throw new IllegalArgumentException("Empty country component in 'value' attribute in &lt;setLocale&gt;");
        }
        return ret;
    }
}

