/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.activemq.artemis.core.version.Version;

public class ActiveMQConnectionMetaData
implements ConnectionMetaData {
    private static final String ACTIVEMQ = "ActiveMQ";
    private final Version serverVersion;

    public ActiveMQConnectionMetaData(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public String getJMSVersion() throws JMSException {
        return "2.0";
    }

    @Override
    public int getJMSMajorVersion() throws JMSException {
        return 2;
    }

    @Override
    public int getJMSMinorVersion() throws JMSException {
        return 0;
    }

    @Override
    public String getJMSProviderName() throws JMSException {
        return ACTIVEMQ;
    }

    @Override
    public String getProviderVersion() throws JMSException {
        return this.serverVersion.getFullVersion();
    }

    @Override
    public int getProviderMajorVersion() throws JMSException {
        return this.serverVersion.getMajorVersion();
    }

    @Override
    public int getProviderMinorVersion() throws JMSException {
        return this.serverVersion.getMinorVersion();
    }

    @Override
    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }
}

