/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.application.InjectionApplicationFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationFactoryImpl
extends ApplicationFactory {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private final Map<String, Application> applicationHolder = new ConcurrentHashMap<String, Application>(1);
    private final String createdBy = Util.generateCreatedBy(FacesContext.getCurrentInstance());

    public ApplicationFactoryImpl() {
        super(null);
        LOGGER.log(Level.FINE, "Created ApplicationFactory ");
    }

    public Application getApplication() {
        return this.applicationHolder.computeIfAbsent("default", e -> {
            ApplicationImpl applicationImpl = new ApplicationImpl();
            InjectionApplicationFactory.setApplicationInstance(applicationImpl);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Created Application instance ''{0}''", this.applicationHolder));
            }
            return applicationImpl;
        });
    }

    public void setApplication(Application application) {
        Util.notNull("application", application);
        this.applicationHolder.put("default", application);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("set Application Instance to ''{0}''", application.getClass().getName()));
        }
    }

    public String toString() {
        return super.toString() + " created by " + this.createdBy;
    }
}

