/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.jboss.logging.Logger;

public class MetricsManager {
    private static final Logger log = Logger.getLogger(MetricsManager.class);
    private final String brokerName;
    private final MeterRegistry meterRegistry;
    private final Map<String, List<Meter>> meters = new ConcurrentHashMap<String, List<Meter>>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;

    public MetricsManager(String brokerName, MetricsConfiguration metricsConfiguration, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.brokerName = brokerName;
        this.meterRegistry = metricsConfiguration.getPlugin().getRegistry();
        Metrics.globalRegistry.add(this.meterRegistry);
        this.addressSettingsRepository = addressSettingsRepository;
        if (metricsConfiguration.isJvmMemory()) {
            new JvmMemoryMetrics().bindTo(this.meterRegistry);
        }
        if (metricsConfiguration.isJvmGc()) {
            new JvmGcMetrics().bindTo(this.meterRegistry);
        }
        if (metricsConfiguration.isJvmThread()) {
            new JvmThreadMetrics().bindTo(this.meterRegistry);
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void registerQueueGauge(String address, String queue, Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder> newMeters = new ArrayList<Gauge.Builder>();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).tag("address", address).tag("queue", queue).description(description);
            newMeters.add(meter);
        });
        String resource = "queue." + queue;
        this.registerMeter(newMeters, resource);
    }

    public void registerAddressGauge(String address, Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder> newMeters = new ArrayList<Gauge.Builder>();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).tag("address", address).description(description);
            newMeters.add(meter);
        });
        String resource = "address." + address;
        this.registerMeter(newMeters, resource);
    }

    public void registerBrokerGauge(Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        ArrayList<Gauge.Builder> newMeters = new ArrayList<Gauge.Builder>();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).description(description);
            newMeters.add(meter);
        });
        String resource = "broker." + this.brokerName;
        this.registerMeter(newMeters, resource);
    }

    private void registerMeter(List<Gauge.Builder> newMeters, String resource) {
        this.meters.compute(resource, (s, meters) -> {
            meters = new ArrayList<Gauge>(newMeters.size());
            for (Gauge.Builder gaugeBuilder : newMeters) {
                Gauge gauge = gaugeBuilder.register(this.meterRegistry);
                meters.add(gauge);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Registered meter: " + gauge.getId()));
            }
            return meters;
        });
    }

    public void remove(String component) {
        this.meters.computeIfPresent(component, (s, meters) -> {
            if (meters == null) {
                return null;
            }
            for (Meter meter : meters) {
                Meter removed = this.meterRegistry.remove(meter);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unregistered meter: " + removed.getId()));
            }
            return null;
        });
    }

    @FunctionalInterface
    public static interface MetricGaugeBuilder {
        public void register(String var1, Object var2, ToDoubleFunction var3, String var4);
    }
}

