/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.inject.InjectionMessages;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigProducerUtil {
    private ConfigProducerUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        return ConfigProducerUtil.convertValue(name, ConfigProducerUtil.resolveConverter(injectionPoint, config), ConfigProducerUtil.getDefaultValue(injectionPoint), config);
    }

    public static <T> T getValue(String name, Type type, String defaultValue, Config config) {
        if (name == null) {
            return null;
        }
        return ConfigProducerUtil.convertValue(name, ConfigProducerUtil.resolveConverter(type, config), defaultValue, config);
    }

    public static <T> T convertValue(String name, Converter<T> converter, String defaultValue, Config config) {
        Object converted;
        String rawValue = ConfigProducerUtil.getRawValue(name, config);
        if (rawValue == null) {
            rawValue = defaultValue;
        }
        if (rawValue == null) {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw InjectionMessages.msg.propertyNotFound(name);
            }
        } else {
            converted = converter.convert(rawValue);
        }
        if (converted == null) {
            throw InjectionMessages.msg.propertyNotFound(name);
        }
        return (T)converted;
    }

    public static org.eclipse.microprofile.config.ConfigValue getConfigValue(InjectionPoint injectionPoint, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        org.eclipse.microprofile.config.ConfigValue configValue = config.getConfigValue(name);
        if (configValue.getRawValue() == null && configValue instanceof ConfigValue) {
            configValue = ((ConfigValue)configValue).withValue(ConfigProducerUtil.getDefaultValue(injectionPoint));
        }
        return configValue;
    }

    public static String getRawValue(String name, Config config) {
        return (String)SecretKeys.doUnlocked(() -> config.getConfigValue(name).getValue());
    }

    public static <T> Converter<T> resolveConverter(InjectionPoint injectionPoint, Config src) {
        return ConfigProducerUtil.resolveConverter(injectionPoint.getType(), src);
    }

    private static <T> Converter<T> resolveConverter(Type type, Config src) {
        Class rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src), ArrayList::new);
            }
            if (rawType == Set.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src), HashSet::new);
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src));
            }
            if (rawType == Supplier.class) {
                return ConfigProducerUtil.resolveConverter(typeArgs[0], src);
            }
        }
        return (Converter)src.getConverter(rawType).orElseThrow(() -> InjectionMessages.msg.noRegisteredConverter(rawType));
    }

    private static <T> Class<T> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigProducerUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigProducerUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw InjectionMessages.msg.noRawType(type);
    }

    public static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    public static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            String str = ((ConfigProperty)qualifier).defaultValue();
            if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(str)) {
                return str;
            }
            Class rawType = ConfigProducerUtil.rawTypeOf(injectionPoint.getType());
            if (rawType.isPrimitive()) {
                if (rawType == Character.TYPE) {
                    return null;
                }
                if (rawType == Boolean.TYPE) {
                    return "false";
                }
                return "0";
            }
            return null;
        }
        return null;
    }

    public static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (!key.trim().isEmpty()) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            String[] parts = declaringType.getJavaClass().getCanonicalName().split("\\.");
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(".").append(parts[i]);
            }
            sb.append(".").append(member.getJavaMember().getName());
            return sb.toString();
        }
        throw InjectionMessages.msg.noConfigPropertyDefaultName(ip);
    }
}

