/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import jakarta.ejb.EJBException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Semaphore;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.TimerTask;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;

public class TimerImpl
implements Timer {
    private String toStringTemplate = null;
    protected final String id;
    protected volatile TimerState timerState;
    protected final TimerServiceImpl timerService;
    protected final TimedObjectInvoker timedObjectInvoker;
    protected final Serializable info;
    protected final boolean persistent;
    protected final TimerHandleImpl handle;
    protected final Date initialExpiration;
    protected final long intervalDuration;
    protected final Object primaryKey;
    protected volatile Date nextExpiration;
    protected volatile Date previousRun;
    private final String timedObjectId;
    private final Semaphore inUseLock = new Semaphore(1);
    private volatile Thread executingThread = null;

    protected TimerImpl(Builder builder, TimerServiceImpl service) {
        assert (builder.id != null) : "id is null";
        this.id = builder.id;
        this.timedObjectId = builder.timedObjectId;
        this.info = builder.info;
        this.persistent = builder.persistent;
        this.initialExpiration = builder.initialDate;
        this.intervalDuration = builder.repeatInterval;
        this.nextExpiration = builder.newTimer && builder.nextDate == null ? this.initialExpiration : builder.nextDate;
        this.previousRun = builder.previousRun;
        this.primaryKey = builder.primaryKey;
        this.timerState = builder.timerState;
        this.timerService = service;
        this.timedObjectInvoker = service.getInvoker();
        this.handle = new TimerHandleImpl(this.id, this.timedObjectInvoker.getTimedObjectId(), service);
        this.executingThread = null;
    }

    public void cancel() throws IllegalStateException, EJBException {
        try {
            this.timerService.cancelTimer(this);
        }
        catch (InterruptedException e) {
            throw new EJBException((Exception)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return false;
    }

    public TimerHandle getHandle() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (!this.persistent) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerHandlersForPersistentTimers("Enterprise Beans 3.1 Spec 18.2.6");
        }
        return this.handle;
    }

    public TimerHandle getTimerHandle() {
        return this.handle;
    }

    public boolean isPersistent() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.persistent;
    }

    public boolean isTimerPersistent() {
        return this.persistent;
    }

    public Serializable getInfo() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.info;
    }

    public Serializable getTimerInfo() {
        return this.info;
    }

    public Date getNextTimeout() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.noMoreTimeoutForTimer(this);
        }
        return this.nextExpiration;
    }

    public Date getNextExpiration() {
        return this.nextExpiration;
    }

    public void setNextTimeout(Date next) {
        if (next == null) {
            this.setTimerState(TimerState.EXPIRED, null);
        }
        this.nextExpiration = next;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.assertTimerState();
        throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerNotCalendarBaseTimer(this);
    }

    public long getTimeRemaining() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.noMoreTimeoutForTimer(this);
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long nextTimeoutInMillis = this.nextExpiration.getTime();
        return nextTimeoutInMillis - currentTimeInMillis;
    }

    public boolean isAutoTimer() {
        return false;
    }

    protected void cancelTimeout() {
        this.timerService.cancelTimeout(this);
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public long getInterval() {
        return this.intervalDuration;
    }

    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    public TimerServiceImpl getTimerService() {
        return this.timerService;
    }

    public boolean isActive() {
        return this.timerService.isStarted() && !this.isCanceled() && !this.isExpired() && (this.timerService.isScheduled(this.getId()) || this.timerState == TimerState.CREATED);
    }

    public boolean isCanceled() {
        return this.timerState == TimerState.CANCELED;
    }

    public boolean isExpired() {
        return this.timerState == TimerState.EXPIRED;
    }

    public boolean isInRetry() {
        return this.timerState == TimerState.RETRY_TIMEOUT;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getState() {
        return this.timerState;
    }

    protected Thread getExecutingThread() {
        return this.executingThread;
    }

    protected void assertTimerState() {
        if (this.timerState == TimerState.EXPIRED) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerHasExpired(this.id);
        }
        if (this.timerState == TimerState.CANCELED) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerWasCanceled(this.id);
        }
        AllowedMethodsInformation.checkAllowed(MethodType.TIMER_SERVICE_METHOD);
    }

    public void setTimerState(TimerState state) {
        this.setTimerState(state, null);
    }

    protected void setTimerState(TimerState state, Thread thread) {
        assert ((state == TimerState.IN_TIMEOUT || state == TimerState.RETRY_TIMEOUT) && thread != null || thread == null) : "Invalid to set timer state " + (Object)((Object)state) + " with executing Thread " + thread;
        this.timerState = state;
        this.executingThread = thread;
    }

    public void suspend() {
        this.cancelTimeout();
    }

    public void invokeOneOff() throws Exception {
        this.getTimerTask().invokeBeanMethod(this);
    }

    public void scheduleTimeout(boolean newTimer) {
        this.timerService.scheduleTimeout(this, newTimer);
    }

    protected TimerTask<?> getTimerTask() {
        return new TimerTask<TimerImpl>(this);
    }

    public void lock() throws InterruptedException {
        this.inUseLock.acquire();
    }

    public void unlock() {
        this.inUseLock.release();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.handle == null) {
            return false;
        }
        if (!(obj instanceof TimerImpl)) {
            return false;
        }
        TimerImpl otherTimer = (TimerImpl)obj;
        return this.handle.equals(otherTimer.getTimerHandle());
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        StringBuilder sb;
        if (this.toStringTemplate == null) {
            sb = new StringBuilder();
            sb.append("[id=");
            sb.append(this.id);
            sb.append(" timedObjectId=");
            sb.append(this.timedObjectId);
            sb.append(" auto-timer?:");
            sb.append(this.isAutoTimer());
            sb.append(" persistent?:");
            sb.append(this.persistent);
            sb.append(" timerService=");
            sb.append(this.timerService);
            sb.append(" previousRun=");
            sb.append(this.previousRun);
            sb.append(" initialExpiration=");
            sb.append(this.initialExpiration);
            sb.append(" intervalDuration(in milli sec)=");
            sb.append(this.intervalDuration);
            this.toStringTemplate = sb.toString();
        }
        sb = new StringBuilder(this.toStringTemplate);
        sb.append(" nextExpiration=");
        sb.append(this.nextExpiration);
        sb.append(" timerState=");
        sb.append((Object)this.timerState);
        sb.append(" info=");
        sb.append(this.info);
        sb.append("]");
        return sb.toString();
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String id;
        protected String timedObjectId;
        protected Date initialDate;
        protected long repeatInterval;
        protected Date nextDate;
        protected Date previousRun;
        protected Serializable info;
        protected Object primaryKey;
        protected TimerState timerState;
        protected boolean persistent;
        protected boolean newTimer;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTimedObjectId(String timedObjectId) {
            this.timedObjectId = timedObjectId;
            return this;
        }

        public Builder setInitialDate(Date initialDate) {
            this.initialDate = initialDate;
            return this;
        }

        public Builder setRepeatInterval(long repeatInterval) {
            this.repeatInterval = repeatInterval;
            return this;
        }

        public Builder setNextDate(Date nextDate) {
            this.nextDate = nextDate;
            return this;
        }

        public Builder setPreviousRun(Date previousRun) {
            this.previousRun = previousRun;
            return this;
        }

        public Builder setInfo(Serializable info) {
            this.info = info;
            return this;
        }

        public Builder setPrimaryKey(Object primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder setTimerState(TimerState timerState) {
            this.timerState = timerState;
            return this;
        }

        public Builder setPersistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder setNewTimer(boolean newTimer) {
            this.newTimer = newTimer;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public String getTimedObjectId() {
            return this.timedObjectId;
        }

        public Date getInitialDate() {
            return this.initialDate;
        }

        public long getRepeatInterval() {
            return this.repeatInterval;
        }

        public Date getNextDate() {
            return this.nextDate;
        }

        public Date getPreviousRun() {
            return this.previousRun;
        }

        public Serializable getInfo() {
            return this.info;
        }

        public Object getPrimaryKey() {
            return this.primaryKey;
        }

        public TimerState getTimerState() {
            return this.timerState;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public boolean isNewTimer() {
            return this.newTimer;
        }

        public TimerImpl build(TimerServiceImpl timerService) {
            return new TimerImpl(this, timerService);
        }
    }
}

