/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.LinkBuilderImpl;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;

public class LinkDelegate
implements RuntimeDelegate.HeaderDelegate<Link> {
    public Link fromString(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.paramNull());
        }
        Parser parser = new Parser(value);
        parser.parse();
        return parser.getLink();
    }

    public String toString(Link value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.paramNull());
        }
        StringBuffer buf = new StringBuffer("<");
        buf.append(value.getUri().toString()).append(">");
        for (Map.Entry entry : value.getParams().entrySet()) {
            buf.append("; ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        return buf.toString();
    }

    private static class Parser {
        private int curr;
        private String value;
        private Link.Builder builder;

        Parser(String value) {
            this.value = value;
            this.builder = new LinkBuilderImpl();
        }

        public Link getLink() {
            return this.builder.build(new Object[0]);
        }

        public void parse() {
            String href = null;
            MultivaluedMapImpl<String, String> attributes = new MultivaluedMapImpl<String, String>();
            while (this.curr < this.value.length()) {
                char c = this.value.charAt(this.curr);
                if (c == '<') {
                    if (href != null) {
                        throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderTooManyLinks(this.value));
                    }
                    href = this.parseLink();
                    continue;
                }
                if (c == ';' || c == ' ') {
                    ++this.curr;
                    continue;
                }
                this.parseAttribute(attributes);
            }
            this.populateLink(href, attributes);
        }

        protected void populateLink(String href, MultivaluedMap<String, String> attributes) {
            this.builder.uri(href);
            for (String name : attributes.keySet()) {
                List values = (List)attributes.get((Object)name);
                if (name.equals("rel")) {
                    for (String val : values) {
                        this.builder.rel(val);
                    }
                    continue;
                }
                if (name.equals("title")) {
                    for (String val : values) {
                        this.builder.title(val);
                    }
                    continue;
                }
                if (name.equals("type")) {
                    for (String val : values) {
                        this.builder.type(val);
                    }
                    continue;
                }
                for (String val : values) {
                    this.builder.param(name, val);
                }
            }
        }

        public String parseLink() {
            int end = this.value.indexOf(62, this.curr);
            if (end == -1) {
                throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToLink(this.value));
            }
            String href = this.value.substring(this.curr + 1, end);
            this.curr = end + 1;
            return href;
        }

        public void parseAttribute(MultivaluedMap<String, String> attributes) {
            int end = this.value.indexOf(61, this.curr);
            if (end == -1 || end + 1 >= this.value.length()) {
                throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
            }
            String name = this.value.substring(this.curr, end);
            name = name.trim();
            this.curr = end + 1;
            String val = null;
            if (this.curr >= this.value.length()) {
                val = "";
            } else if (this.value.charAt(this.curr) == '\"') {
                if (this.curr + 1 >= this.value.length()) {
                    throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
                }
                ++this.curr;
                end = this.value.indexOf(34, this.curr);
                if (end == -1) {
                    throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
                }
                val = this.value.substring(this.curr, end);
                this.curr = end + 1;
            } else {
                char c;
                StringBuffer buf = new StringBuffer();
                while (this.curr < this.value.length() && (c = this.value.charAt(this.curr)) != ',' && c != ';') {
                    buf.append(this.value.charAt(this.curr));
                    ++this.curr;
                }
                val = buf.toString();
            }
            attributes.add((Object)name, (Object)val);
        }
    }
}

