/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.AcceptParser;

@ConstrainedTo(value=RuntimeType.SERVER)
@Priority(value=3000)
public class ServerContentEncodingAnnotationFilter
implements WriterInterceptor {
    @Context
    protected HttpRequest request;
    Set<String> encodings;

    public ServerContentEncodingAnnotationFilter(Set<String> encodings) {
        this.encodings = encodings;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get((Object)"Accept-Encoding");
        if (acceptEncoding != null) {
            StringBuffer buf = new StringBuffer();
            for (String accept : acceptEncoding) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(accept);
            }
            List<String> accepts = AcceptParser.parseAcceptHeader(buf.toString());
            for (String encoding : accepts) {
                if (!this.encodings.contains(encoding.toLowerCase())) continue;
                context.getHeaders().putSingle((Object)"Content-Encoding", (Object)encoding);
                break;
            }
        }
        context.proceed();
    }
}

