/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.Incomings;
import io.smallrye.reactive.messaging.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.extension.ChannelProducer;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.extension.HealthCenter;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;

public class ReactiveMessagingExtension
implements Extension {
    private final List<MediatorBean<?>> mediatorBeans = new ArrayList();
    private final List<InjectionPoint> streamInjectionPoints = new ArrayList<InjectionPoint>();
    private final List<InjectionPoint> emitterInjectionPoints = new ArrayList<InjectionPoint>();
    private final List<InjectionPoint> mutinyEmitterInjectionPoints = new ArrayList<InjectionPoint>();
    private final List<WorkerPoolBean<?>> workerPoolBeans = new ArrayList();
    @Inject
    HealthCenter health;

    <T> void processClassesContainingMediators(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        if (annotatedType.getMethods().stream().anyMatch(m -> m.isAnnotationPresent(Incomings.class) || m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class))) {
            this.mediatorBeans.add(new MediatorBean(event.getBean(), event.getAnnotatedBeanClass()));
        }
    }

    <T> void processBlockingAnnotation(@Observes @WithAnnotations(value={Blocking.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        this.workerPoolBeans.add(new WorkerPoolBean(annotatedType));
    }

    <T extends Publisher<?>> void processStreamPublisherInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends org.eclipse.microprofile.reactive.messaging.Emitter<?>> void processStreamEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.emitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends MutinyEmitter<?>> void processStreamMutinyEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.mutinyEmitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends Emitter<?>> void processStreamLegacyEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.emitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends PublisherBuilder<?>> void processStreamPublisherBuilderInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation done, BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        MediatorManager mediatorManager = (MediatorManager)instance.select(MediatorManager.class, new Annotation[0]).get();
        WorkerPoolRegistry workerPoolRegistry = (WorkerPoolRegistry)instance.select(WorkerPoolRegistry.class, new Annotation[0]).get();
        List<EmitterConfiguration> emitters = this.createEmitterConfigurations();
        for (EmitterConfiguration emitter : emitters) {
            mediatorManager.addEmitter(emitter);
        }
        List<ChannelConfiguration> channels = this.createChannelConfigurations();
        for (ChannelConfiguration channelConfiguration : channels) {
            mediatorManager.addChannel(channelConfiguration);
        }
        for (MediatorBean mediatorBean : this.mediatorBeans) {
            ProviderLogging.log.analyzingMediatorBean(mediatorBean.bean);
            mediatorManager.analyze(mediatorBean.annotatedType, mediatorBean.bean);
        }
        for (WorkerPoolBean workerPoolBean : this.workerPoolBeans) {
            workerPoolRegistry.analyzeWorker(workerPoolBean.annotatedType);
        }
        mediatorManager.start();
    }

    private List<ChannelConfiguration> createChannelConfigurations() {
        ArrayList<ChannelConfiguration> channels = new ArrayList<ChannelConfiguration>();
        for (InjectionPoint ip : this.streamInjectionPoints) {
            String name = ChannelProducer.getChannelName(ip);
            channels.add(new ChannelConfiguration(name));
        }
        return channels;
    }

    private List<EmitterConfiguration> createEmitterConfigurations() {
        ArrayList<EmitterConfiguration> emitters = new ArrayList<EmitterConfiguration>();
        this.createEmitterConfiguration(this.emitterInjectionPoints, false, emitters);
        this.createEmitterConfiguration(this.mutinyEmitterInjectionPoints, true, emitters);
        return emitters;
    }

    private void createEmitterConfiguration(List<InjectionPoint> emitterInjectionPoints, boolean isMutinyEmitter, List<EmitterConfiguration> emitters) {
        for (InjectionPoint point : emitterInjectionPoints) {
            String name = ChannelProducer.getChannelName(point);
            OnOverflow onOverflow = (OnOverflow)point.getAnnotated().getAnnotation(OnOverflow.class);
            if (onOverflow == null) {
                onOverflow = this.createOnOverflowForLegacyAnnotation(point);
            }
            Broadcast broadcast = (Broadcast)point.getAnnotated().getAnnotation(Broadcast.class);
            emitters.add(new EmitterConfiguration(name, isMutinyEmitter, onOverflow, broadcast));
        }
    }

    private OnOverflow createOnOverflowForLegacyAnnotation(InjectionPoint point) {
        final io.smallrye.reactive.messaging.annotations.OnOverflow legacy = (io.smallrye.reactive.messaging.annotations.OnOverflow)point.getAnnotated().getAnnotation(io.smallrye.reactive.messaging.annotations.OnOverflow.class);
        if (legacy != null) {
            return new OnOverflow(){

                public Class<? extends Annotation> annotationType() {
                    return OnOverflow.class;
                }

                public OnOverflow.Strategy value() {
                    return OnOverflow.Strategy.valueOf((String)legacy.value().name());
                }

                public long bufferSize() {
                    return legacy.bufferSize();
                }
            };
        }
        return null;
    }

    static class WorkerPoolBean<T> {
        final AnnotatedType<T> annotatedType;

        WorkerPoolBean(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
        }
    }

    static class MediatorBean<T> {
        final Bean<T> bean;
        final AnnotatedType<T> annotatedType;

        MediatorBean(Bean<T> bean, AnnotatedType<T> annotatedType) {
            this.bean = bean;
            this.annotatedType = annotatedType;
        }
    }
}

