/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.impl.ConfiguredChannelFactory;
import io.smallrye.reactive.messaging.impl.ConnectorConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;

@ApplicationScoped
public class LegacyConfiguredChannelFactory
extends ConfiguredChannelFactory {
    private static final String SOURCE_CONFIG_PREFIX = "smallrye.messaging.source.";
    private static final String SINK_CONFIG_PREFIX = "smallrye.messaging.sink.";

    protected LegacyConfiguredChannelFactory() {
    }

    @Inject
    public LegacyConfiguredChannelFactory(@Any Instance<IncomingConnectorFactory> incomingConnectorFactories, @Any Instance<OutgoingConnectorFactory> outgoingConnectorFactories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, BeanManager beanManager) {
        super(incomingConnectorFactories, outgoingConnectorFactories, config, registry, beanManager, false);
    }

    @Override
    public void initialize() {
        if (this.config == null) {
            return;
        }
        Map<String, ConnectorConfig> sourceConfiguration = LegacyConfiguredChannelFactory.extractConfigurationFor(SOURCE_CONFIG_PREFIX, this.config);
        Map<String, ConnectorConfig> sinkConfiguration = LegacyConfiguredChannelFactory.extractConfigurationFor(SINK_CONFIG_PREFIX, this.config);
        this.register(sourceConfiguration, sinkConfiguration);
    }
}

