/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRequestContext
implements RequestContext {
    private Map<String, Object> map = new HashMap<String, Object>();
    private Node documentElement = null;

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public Node getDocumentElement() {
        return this.documentElement;
    }

    @Override
    public void setRequest(RequestType requestType) throws IOException {
        JAXBElement<RequestType> requestJAXB = new ObjectFactory().createRequest(requestType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXB.marshal(requestJAXB, (OutputStream)baos);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        this.readRequest(bis);
    }

    @Override
    public void readRequest(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Inputstream is null");
        }
        try {
            Node root;
            this.documentElement = root = this.getRequest(is);
            if (root == null) {
                throw new IllegalStateException("Root node read from the input stream is null");
            }
            RequestCtx request = RequestCtx.getInstance(root);
            this.set("request_ctx", request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readRequest(Node node) throws IOException {
        this.documentElement = node;
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        try {
            RequestCtx request = RequestCtx.getInstance(node);
            this.set("request_ctx", request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshall(OutputStream os) throws IOException {
        RequestCtx storedRequest = (RequestCtx)this.get("request_ctx");
        if (storedRequest != null) {
            storedRequest.encode(os);
        }
    }

    @Override
    public Element asElement(Document root) {
        String contextSchema = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
        NodeList nodes = root.getElementsByTagNameNS(contextSchema, "Request");
        return (Element)nodes.item(0);
    }

    private Node getRequest(InputStream is) throws Exception {
        String contextSchema = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        Document doc = factory.newDocumentBuilder().parse(is);
        NodeList nodes = doc.getElementsByTagNameNS(contextSchema, "Request");
        return nodes.item(0);
    }
}

