/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt.consumer;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UncheckedJoseException;

public class TypeValidator
implements ErrorCodeValidator {
    private static final String APPLICATION_PRIMARY_TYPE = "application";
    private MimeType expectedType;
    private boolean requireType;

    public TypeValidator(boolean requireType, String expectedType) {
        try {
            this.expectedType = this.toMediaType(expectedType);
            if (this.expectedType.getSubType().equals("*")) {
                throw new MimeTypeParseException("cannot use wildcard in subtype");
            }
        }
        catch (MimeTypeParseException e) {
            throw new UncheckedJoseException("The given expected type '" + expectedType + "' isn't a valid media type in this context.", e);
        }
        this.requireType = requireType;
    }

    @Override
    public ErrorCodeValidator.Error validate(JwtContext jwtContext) {
        JsonWebStructure jsonWebThing = jwtContext.getJoseObjects().get(0);
        String type = jsonWebThing.getHeader("typ");
        return this.validate(type);
    }

    ErrorCodeValidator.Error validate(String type) {
        if (type == null) {
            return this.requireType ? new ErrorCodeValidator.Error(21, "No typ header parameter present in the innermost JWS/JWE") : null;
        }
        if (this.expectedType != null) {
            try {
                MimeType mediaType = this.toMediaType(type);
                if (!this.expectedType.match(mediaType) || mediaType.getSubType().equals("*")) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Invalid typ header parameter value '").append(type).append("'. Expecting '");
                    msg.append(this.expectedType).append("'");
                    if (this.expectedType.getPrimaryType().equals(APPLICATION_PRIMARY_TYPE)) {
                        msg.append(" or just '").append(this.expectedType.getSubType()).append("'");
                    }
                    msg.append(".");
                    return new ErrorCodeValidator.Error(22, msg.toString());
                }
            }
            catch (MimeTypeParseException e) {
                return new ErrorCodeValidator.Error(22, "typ header parameter value '" + type + "' not parsable as a media type " + (Object)((Object)e));
            }
        }
        return null;
    }

    MimeType toMediaType(String type) throws MimeTypeParseException {
        return type.contains("/") ? new MimeType(type) : new MimeType(APPLICATION_PRIMARY_TYPE, type);
    }
}

