/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.DecoratorMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SynchronizedDecoratorMarshaller<T>
extends DecoratorMarshaller<T> {
    public SynchronizedDecoratorMarshaller(Class<T> decoratedClass, UnaryOperator<T> decorator, T sample) {
        super(decoratedClass, decorator, sample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        Object decorated = WildFlySecurityManager.doUnchecked(value, (ParametricPrivilegedAction)this);
        if (decorated != null) {
            Object object = decorated;
            synchronized (object) {
                writer.writeObject(1, new Any(decorated));
            }
        }
    }
}

