/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Method;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class JBossStandaloneJTAManagerLookup
implements TransactionManagerLookup {
    private Method manager;
    private Method user;
    private static final Log log = LogFactory.getLog(JBossStandaloneJTAManagerLookup.class);

    @Inject
    public void init(GlobalConfiguration globalCfg) {
        this.init(globalCfg.classLoader());
    }

    private void init(ClassLoader classLoader) {
        try {
            this.manager = Util.loadClass((String)"com.arjuna.ats.jta.TransactionManager", (ClassLoader)classLoader).getMethod("transactionManager", new Class[0]);
            this.user = Util.loadClass((String)"com.arjuna.ats.jta.UserTransaction", (ClassLoader)classLoader).getMethod("userTransaction", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized TransactionManager getTransactionManager() throws Exception {
        TransactionManager tm = (TransactionManager)this.manager.invoke(null, new Object[0]);
        if (log.isInfoEnabled()) {
            log.retrievingTm(tm);
        }
        return tm;
    }

    public UserTransaction getUserTransaction() throws Exception {
        return (UserTransaction)this.user.invoke(null, new Object[0]);
    }

    public String toString() {
        return "JBossStandaloneJTAManagerLookup";
    }
}

