/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;

public class CommandDispatcherMarshaller<C, MC>
implements CommandMarshaller<C> {
    private final ByteBufferMarshaller marshaller;
    private final Object id;
    private final MarshalledValueFactory<MC> factory;

    public CommandDispatcherMarshaller(ByteBufferMarshaller marshaller, Object id, MarshalledValueFactory<MC> factory) {
        this.marshaller = marshaller;
        this.id = id;
        this.factory = factory;
    }

    @Override
    public <R> ByteBuffer marshal(Command<R, ? super C> command) throws IOException {
        MarshalledValue value = this.factory.createMarshalledValue(command);
        AbstractMap.SimpleImmutableEntry<Object, MarshalledValue> entry = new AbstractMap.SimpleImmutableEntry<Object, MarshalledValue>(this.id, value);
        return this.marshaller.write(entry);
    }
}

