/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.oob.OOBSession;

public class SessionAttributeActivationNotifierFactory<S, SC, AL, LC, B extends Batch>
implements Function<String, SessionAttributeActivationNotifier>,
Registrar<Map.Entry<SC, SessionManager<LC, B>>> {
    private final Map<SC, SessionManager<LC, B>> contexts = new ConcurrentHashMap<SC, SessionManager<LC, B>>();
    private final HttpSessionActivationListenerProvider<S, SC, AL> provider;
    private final Function<AL, Consumer<S>> prePassivateNotifier;
    private final Function<AL, Consumer<S>> postActivateNotifier;

    public SessionAttributeActivationNotifierFactory(HttpSessionActivationListenerProvider<S, SC, AL> provider) {
        this.provider = provider;
        this.prePassivateNotifier = arg_0 -> provider.prePassivateNotifier(arg_0);
        this.postActivateNotifier = arg_0 -> provider.postActivateNotifier(arg_0);
    }

    public Registration register(Map.Entry<SC, SessionManager<LC, B>> entry) {
        SC context = entry.getKey();
        this.contexts.put(context, entry.getValue());
        return () -> this.contexts.remove(context);
    }

    @Override
    public SessionAttributeActivationNotifier apply(final String sessionId) {
        final Map<SC, SessionManager<LC, B>> contexts = this.contexts;
        final HttpSessionActivationListenerProvider<S, SC, AL> provider = this.provider;
        final Function<AL, Consumer<S>> prePassivateNotifier = this.prePassivateNotifier;
        final Function<AL, Consumer<S>> postActivateNotifier = this.postActivateNotifier;
        return new SessionAttributeActivationNotifier(){

            public void prePassivate(Object value) {
                this.notify(prePassivateNotifier, value);
            }

            public void postActivate(Object value) {
                this.notify(postActivateNotifier, value);
            }

            public void notify(Function<AL, Consumer<S>> notifier, Object value) {
                Class listenerClass = provider.getHttpSessionActivationListenerClass();
                if (listenerClass.isInstance(value)) {
                    Object listener = listenerClass.cast(value);
                    for (Map.Entry entry : contexts.entrySet()) {
                        Object context = entry.getKey();
                        SessionManager manager = (SessionManager)entry.getValue();
                        OOBSession session = new OOBSession(manager, sessionId, null);
                        notifier.apply(listener).accept(provider.createHttpSession((ImmutableSession)session, context));
                    }
                }
            }

            public void close() {
            }
        };
    }
}

