/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.io.IOException;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.security.doseta.AbstractDigitalSigningHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerDigitalSigningHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Signed signed = resourceInfo.getResourceMethod().getAnnotation(Signed.class);
        if (signed == null) {
            signed = resourceInfo.getResourceClass().getAnnotation(Signed.class);
        }
        if (signed == null) {
            return;
        }
        configurable.register((Object)new DigitalSigningHeaderDecorator(signed));
    }

    @Priority(value=3000)
    public static class DigitalSigningHeaderDecorator
    extends AbstractDigitalSigningHeaderDecorator
    implements ContainerResponseFilter {
        public DigitalSigningHeaderDecorator(Signed signed) {
            this.signed = signed;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            KeyRepository repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            DKIMSignature header = this.createHeader(repository);
            responseContext.getHeaders().add((Object)"DKIM-Signature", (Object)header);
        }
    }
}

