/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jms.impl;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.search.backend.jms.impl.JmsBackendQueueProcessor;
import org.hibernate.search.engine.service.named.spi.NamedResolver;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JndiJMSBackendQueueProcessor
extends JmsBackendQueueProcessor {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected QueueConnectionFactory initializeJMSQueueConnectionFactory(Properties properties) {
        String jmsConnectionFactoryName = properties.getProperty("worker.jms.connection_factory");
        try (ServiceReference requestReference = this.getServiceManager().requestReference(NamedResolver.class);){
            Object located = ((NamedResolver)requestReference.get()).locate(jmsConnectionFactoryName);
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)located;
            return queueConnectionFactory;
        }
        catch (RuntimeException e) {
            throw log.jmsQueueFactoryLookupException(jmsConnectionFactoryName, this.getIndexName(), (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Queue initializeJMSQueue(QueueConnectionFactory factory, Properties properties) {
        try (ServiceReference requestReference = this.getServiceManager().requestReference(NamedResolver.class);){
            Object located = ((NamedResolver)requestReference.get()).locate(this.getJmsQueueName());
            Queue queue = (Queue)located;
            return queue;
        }
        catch (RuntimeException e) {
            throw log.jmsQueueLookupException(this.getJmsQueueName(), this.getIndexName(), (Throwable)e);
        }
    }

    @Override
    protected QueueConnection initializeJMSConnection(QueueConnectionFactory factory, Properties properties) {
        String login = properties.getProperty("worker.jms.login");
        String password = properties.getProperty("worker.jms.password");
        try {
            if (login == null && password == null) {
                return factory.createQueueConnection();
            }
            return factory.createQueueConnection(login, password);
        }
        catch (JMSException e) {
            throw log.unableToOpenJMSConnection(this.getIndexName(), this.getJmsQueueName(), (Throwable)e);
        }
    }
}

