/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProducerFlowControlTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    private ClientSessionFactory sf;
    private ClientSession session;
    private ActiveMQServer server;

    protected boolean isNetty() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createFactory(this.isNetty());
    }

    @Test
    public void testFlowControlSingleConsumer() throws Exception {
        this.testFlowControl(1000, 500, 10240, 1024, 1024, 1024, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlAnon() throws Exception {
        this.testFlowControl(1000, 500, 10240, 1024, 1024, 1024, 1, 1, 0L, true);
    }

    @Test
    public void testFlowControlSingleConsumerLargeMaxSize() throws Exception {
        this.testFlowControl(1000, 500, 0x100000, 1024, 1024, 1024, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlMultipleConsumers() throws Exception {
        this.testFlowControl(1000, 500, -1, 1024, 1024, 1024, 5, 1, 0L, false);
    }

    @Test
    public void testFlowControlZeroConsumerWindowSize() throws Exception {
        this.testFlowControl(1000, 500, 10240, 1024, 0, 1024, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlZeroAckBatchSize() throws Exception {
        this.testFlowControl(1000, 500, 10240, 1024, 1024, 0, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlSingleConsumerSlowConsumer() throws Exception {
        this.testFlowControl(100, 500, 1024, 512, 512, 512, 1, 1, 10L, false);
    }

    @Test
    public void testFlowControlSmallMessages() throws Exception {
        this.testFlowControl(1000, 0, 10240, 1024, 1024, 1024, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlLargerMessagesSmallWindowSize() throws Exception {
        this.testFlowControl(1000, 10240, 10240, 1024, 1024, 1024, 1, 1, 0L, false);
    }

    @Test
    public void testFlowControlMultipleProducers() throws Exception {
        this.testFlowControl(1000, 500, 0x100000, 1024, 1024, 1024, 1, 5, 0L, false);
    }

    @Test
    public void testFlowControlMultipleProducersAndConsumers() throws Exception {
        this.testFlowControl(500, 500, 102400, 1024, 1024, 1024, 1, 3, 3L, false);
    }

    @Test
    public void testFlowControlMultipleProducersAnon() throws Exception {
        this.testFlowControl(1000, 500, 0x100000, 1024, 1024, 1024, 1, 5, 0L, true);
    }

    @Test
    public void testFlowControlLargeMessages2() throws Exception {
        this.testFlowControl(1000, 10000, -1, 1024, 0, 0, 1, 1, 0L, false, 1000, true);
    }

    @Test
    public void testFlowControlLargeMessages3() throws Exception {
        this.testFlowControl(1000, 10000, 102400, 1024, 1024, 0, 1, 1, 0L, false, 1000, true);
    }

    @Test
    public void testFlowControlLargeMessages4() throws Exception {
        this.testFlowControl(1000, 10000, 102400, 1024, 1024, 1024, 1, 1, 0L, false, 1000, true);
    }

    @Test
    public void testFlowControlLargeMessages5() throws Exception {
        this.testFlowControl(1000, 10000, 102400, 1024, -1, 1024, 1, 1, 0L, false, 1000, true);
    }

    @Test
    public void testFlowControlLargeMessages6() throws Exception {
        this.testFlowControl(1000, 10000, 102400, 1024, 1024, 1024, 1, 1, 0L, true, 1000, true);
    }

    @Test
    public void testFlowControlLargeMessages7() throws Exception {
        this.testFlowControl(1000, 10000, 102400, 1024, 1024, 1024, 2, 2, 0L, true, 1000, true);
    }

    private void testFlowControl(int numMessages, int messageSize, int maxSize, int producerWindowSize, int consumerWindowSize, int ackBatchSize, int numConsumers, int numProducers, long consumerDelay, boolean anon) throws Exception {
        this.testFlowControl(numMessages, messageSize, maxSize, producerWindowSize, consumerWindowSize, ackBatchSize, numConsumers, numProducers, consumerDelay, anon, -1, false);
    }

    private void testFlowControl(final int numMessages, final int messageSize, int maxSize, int producerWindowSize, int consumerWindowSize, int ackBatchSize, int numConsumers, final int numProducers, final long consumerDelay, boolean anon, int minLargeMessageSize, boolean realFiles) throws Exception {
        int i;
        SimpleString address = new SimpleString("testaddress");
        this.server = this.createServer(realFiles, this.isNetty());
        AddressSettings addressSettings = new AddressSettings().setMaxSizeBytes((long)maxSize).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        HierarchicalRepository repos = this.server.getAddressSettingsRepository();
        repos.addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator.setProducerWindowSize(producerWindowSize).setConsumerWindowSize(consumerWindowSize).setAckBatchSize(ackBatchSize);
        if (minLargeMessageSize != -1) {
            this.locator.setMinLargeMessageSize(minLargeMessageSize);
        }
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.start();
        String queueName = "testqueue";
        for (int i2 = 0; i2 < numConsumers; ++i2) {
            this.session.createQueue(new QueueConfiguration(new SimpleString("testqueue" + i2)).setAddress(address).setDurable(Boolean.valueOf(false)));
        }
        final byte[] bytes = RandomUtil.randomBytes((int)messageSize);
        class MyHandler
        implements MessageHandler {
            int count = 0;
            final CountDownLatch latch = new CountDownLatch(1);
            volatile Exception exception;

            MyHandler() {
            }

            public void onMessage(ClientMessage message) {
                try {
                    byte[] bytesRead = new byte[messageSize];
                    message.getBodyBuffer().readBytes(bytesRead);
                    ActiveMQTestBase.assertEqualsByteArrays((byte[])bytes, (byte[])bytesRead);
                    message.acknowledge();
                    if (++this.count == numMessages * numProducers) {
                        this.latch.countDown();
                    }
                    if (consumerDelay > 0L) {
                        Thread.sleep(consumerDelay);
                    }
                }
                catch (Exception e) {
                    ProducerFlowControlTest.this.instanceLog.error((Object)"Failed to handle message", (Throwable)e);
                    this.exception = e;
                    this.latch.countDown();
                }
            }
        }
        MyHandler[] handlers = new MyHandler[numConsumers];
        for (int i3 = 0; i3 < numConsumers; ++i3) {
            handlers[i3] = new MyHandler();
            ClientConsumer consumer = this.session.createConsumer(new SimpleString("testqueue" + i3));
            consumer.setMessageHandler((MessageHandler)handlers[i3]);
        }
        ClientProducer[] producers = new ClientProducer[numProducers];
        for (int i4 = 0; i4 < numProducers; ++i4) {
            producers[i4] = anon ? this.session.createProducer() : this.session.createProducer(address);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < numMessages; ++i) {
            ClientMessage message = this.session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            for (int j = 0; j < numProducers; ++j) {
                if (anon) {
                    producers[j].send(address, (Message)message);
                    continue;
                }
                producers[j].send((Message)message);
            }
        }
        for (i = 0; i < numConsumers; ++i) {
            Assert.assertTrue((boolean)handlers[i].latch.await(5L, TimeUnit.MINUTES));
            Assert.assertNull((Object)handlers[i].exception);
        }
        long end = System.currentTimeMillis();
        double rate = 1000.0 * (double)numMessages / (double)(end - start);
        this.instanceLog.debug((Object)("rate is " + rate + " msgs / sec"));
    }

    @Test
    public void testClosingSessionUnblocksBlockedProducer() throws Exception {
        SimpleString address = new SimpleString("testaddress");
        this.server = this.createServer(false, this.isNetty());
        AddressSettings addressSettings = new AddressSettings().setMaxSizeBytes(1024L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        HierarchicalRepository repos = this.server.getAddressSettingsRepository();
        repos.addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator.setProducerWindowSize(1024).setConsumerWindowSize(1024).setAckBatchSize(1024);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        SimpleString queueName = new SimpleString("testqueue");
        this.session.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        byte[] bytes = new byte[2000];
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeBytes(bytes);
        final AtomicBoolean closed = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    closed.set(true);
                    ProducerFlowControlTest.this.session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        try {
            for (int i = 0; i < 10; ++i) {
                producer.send((Message)message);
            }
        }
        catch (ActiveMQObjectClosedException activeMQObjectClosedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)closed.get());
        t.join();
    }

    @Test
    public void testFlowControlMessageNotRouted() throws Exception {
        SimpleString address = new SimpleString("testaddress");
        this.server = this.createServer(false, this.isNetty());
        AddressSettings addressSettings = new AddressSettings().setMaxSizeBytes(1024L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        HierarchicalRepository repos = this.server.getAddressSettingsRepository();
        repos.addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator.setProducerWindowSize(1024).setConsumerWindowSize(1024).setAckBatchSize(1024);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        ClientProducer producer = this.session.createProducer(address);
        byte[] bytes = new byte[100];
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = this.session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            producer.send((Message)message);
        }
    }

    @Test
    public void testMultipleConsumers() throws Exception {
        int i;
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        this.session.createQueue(new QueueConfiguration("queue2").setAddress("address").setDurable(Boolean.valueOf(false)));
        this.session.createQueue(new QueueConfiguration("queue3").setAddress("address").setDurable(Boolean.valueOf(false)));
        this.session.createQueue(new QueueConfiguration("queue4").setAddress("address").setDurable(Boolean.valueOf(false)));
        this.session.createQueue(new QueueConfiguration("queue5").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer1 = this.session.createConsumer("queue1");
        ClientConsumer consumer2 = this.session.createConsumer("queue2");
        ClientConsumer consumer3 = this.session.createConsumer("queue3");
        ClientConsumer consumer4 = this.session.createConsumer("queue4");
        ClientConsumer consumer5 = this.session.createConsumer("queue5");
        ClientProducer producer = this.session.createProducer("address");
        byte[] bytes = new byte[2000];
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeBytes(bytes);
        int numMessages = 1000;
        for (i = 0; i < 1000; ++i) {
            producer.send((Message)message);
        }
        this.session.start();
        for (i = 0; i < 1000; ++i) {
            ClientMessage msg = consumer1.receive(1000L);
            Assert.assertNotNull((Object)msg);
            msg = consumer2.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg = consumer3.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg = consumer4.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg = consumer5.receive(5000L);
            Assert.assertNotNull((Object)msg);
        }
    }

    @Test
    public void testProducerCreditsCaching1() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducerCredits credits = null;
        for (int i = 0; i < 2000; ++i) {
            ClientProducer prod = this.session.createProducer("address");
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            if (credits != null) {
                Assert.assertTrue((newCredits == credits ? (byte)1 : 0) != 0);
            }
            credits = newCredits;
            Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching2() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducerCredits credits = null;
        for (int i = 0; i < 2000; ++i) {
            ClientProducer prod = this.session.createProducer("address");
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            if (credits != null) {
                Assert.assertTrue((newCredits == credits ? (byte)1 : 0) != 0);
            }
            credits = newCredits;
            prod.close();
            Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching3() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducerCredits credits = null;
        for (int i = 0; i < 1000; ++i) {
            ClientProducer prod = this.session.createProducer("address" + i);
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            if (credits != null) {
                Assert.assertFalse((newCredits == credits ? (byte)1 : 0) != 0);
            }
            credits = newCredits;
            Assert.assertEquals((long)(i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching4() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducerCredits credits = null;
        for (int i = 0; i < 1000; ++i) {
            ClientProducer prod = this.session.createProducer("address" + i);
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            if (credits != null) {
                Assert.assertFalse((newCredits == credits ? (byte)1 : 0) != 0);
            }
            credits = newCredits;
            prod.close();
            Assert.assertEquals((long)(i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)(i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching5() throws Exception {
        int i;
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducerCredits credits = null;
        ArrayList<ClientProducerCredits> creditsList = new ArrayList<ClientProducerCredits>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            ClientProducer prod = this.session.createProducer("address" + i2);
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            if (credits != null) {
                Assert.assertFalse((newCredits == credits ? (byte)1 : 0) != 0);
            }
            credits = newCredits;
            Assert.assertEquals((long)(i2 + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
            creditsList.add(credits);
        }
        Iterator iter = creditsList.iterator();
        for (i = 0; i < 1000; ++i) {
            ClientProducer prod = this.session.createProducer("address" + i);
            ClientProducerCredits newCredits = ((ClientProducerInternal)prod).getProducerCredits();
            Assert.assertTrue((newCredits == iter.next() ? (byte)1 : 0) != 0);
            Assert.assertEquals((long)1000L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
        for (i = 0; i < 10; ++i) {
            this.session.createProducer("address" + (i + 1000));
            Assert.assertEquals((long)(1000 + i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching6() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        for (int i = 0; i < 1000; ++i) {
            ClientProducer prod = this.session.createProducer((String)null);
            prod.send("address", (Message)this.session.createMessage(false));
            Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsCaching7() throws Exception {
        ClientProducer prod;
        int i;
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        for (i = 0; i < 1000; ++i) {
            prod = this.session.createProducer((String)null);
            prod.send("address" + i, (Message)this.session.createMessage(false));
            Assert.assertEquals((long)(i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)(i + 1), (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
        for (i = 0; i < 10; ++i) {
            prod = this.session.createProducer((String)null);
            prod.send("address" + i, (Message)this.session.createMessage(false));
            Assert.assertEquals((long)1000L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)1000L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
        for (i = 0; i < 10; ++i) {
            prod = this.session.createProducer((String)null);
            prod.send("address2-" + i, (Message)this.session.createMessage(false));
            Assert.assertEquals((long)1000L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
            Assert.assertEquals((long)1000L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        }
    }

    @Test
    public void testProducerCreditsRefCounting() throws Exception {
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
        this.waitForServerToStart(this.server);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true, true);
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("address").setDurable(Boolean.valueOf(false)));
        ClientProducer prod1 = this.session.createProducer("address");
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        ClientProducer prod2 = this.session.createProducer("address");
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        ClientProducer prod3 = this.session.createProducer("address");
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        prod1.close();
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        prod2.close();
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)0L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
        prod3.close();
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().creditsMapSize());
        Assert.assertEquals((long)1L, (long)((ClientSessionInternal)this.session).getProducerCreditManager().unReferencedCreditsSize());
    }
}

