/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.wildfly.common.Assert;

public class CommandRegistry {
    private final Map<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();
    private final Set<String> tabCompletionCommands = new HashSet<String>();

    public void registerHandler(CommandHandler handler, String ... names) throws CommandLineException {
        this.registerHandler(handler, true, names);
    }

    public void registerHandler(CommandHandler handler, boolean tabComplete, String ... names) throws RegisterHandlerException {
        String tabCompleteName = null;
        RegisterHandlerException error = null;
        for (String name : names) {
            if (this.handlers.containsKey(name)) {
                if (error == null) {
                    error = new RegisterHandlerException(name);
                    continue;
                }
                error.addCommand(name);
                continue;
            }
            if (tabCompleteName == null) {
                tabCompleteName = name;
            }
            this.handlers.put(name, handler);
        }
        if (tabComplete && tabCompleteName != null) {
            this.tabCompletionCommands.add(tabCompleteName);
        }
        if (error != null) {
            throw error;
        }
    }

    public Set<String> getTabCompletionCommands() {
        return this.tabCompletionCommands;
    }

    public CommandHandler getCommandHandler(String command) {
        return this.handlers.get(command);
    }

    public CommandHandler remove(String cmdName) {
        Assert.checkNotNullParam((String)"cmdName", (Object)cmdName);
        CommandHandler handler = this.handlers.remove(cmdName);
        if (handler != null) {
            this.tabCompletionCommands.remove(cmdName);
        }
        return handler;
    }

    public static class RegisterHandlerException
    extends CommandLineException {
        private static final long serialVersionUID = 1L;
        private List<String> names;

        public RegisterHandlerException(String commandName) {
            super("");
            this.names = Collections.singletonList(commandName);
        }

        public void addCommand(String name) {
            if (this.names.size() == 1) {
                this.names = new ArrayList<String>(this.names);
            }
            this.names.add(name);
        }

        public List<String> getNotAddedNames() {
            return Collections.unmodifiableList(this.names);
        }

        @Override
        public String getMessage() {
            StringBuilder buf = new StringBuilder("The following command names could not be registered since they conflict with the already registered ones: ");
            buf.append(this.names.get(0));
            for (int i = 1; i < this.names.size(); ++i) {
                buf.append(", ").append(this.names.get(i));
            }
            return buf.toString();
        }
    }
}

