/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AmqpLargeMessageTest
extends AmqpClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AmqpLargeMessageTest.class);
    private final Random rand = new Random(System.currentTimeMillis());
    @Parameterized.Parameter(value=0)
    public int frameSize = Short.MAX_VALUE;
    @Parameterized.Parameter(value=1)
    public int payload = 112640;
    @Parameterized.Parameter(value=2)
    public int amqpMinLargeMessageSize = 102400;
    String testQueueName = "ConnectionFrameSize";

    @Parameterized.Parameters(name="frameSize={0}, payload={1}, amqpMinLargeMessageSize={2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Short.MAX_VALUE, 112640, 102400}, {204800, 0x113000, 450560});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setJournalFileSize(0x500000);
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("maxFrameSize", this.frameSize);
        params.put("amqpMinLargeMessageSize", this.amqpMinLargeMessageSize);
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("tcp", "tcp://localhost:61616");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAMQPReceiveCore() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), this.testQueueName);
            AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
            org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            this.receiveJMS(nMsgs, (ConnectionFactory)factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAMQPMessageWithComplexAnnotationsReceiveCore() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            connection.connect();
            String annotation = "x-opt-embedded-map";
            LinkedHashMap<String, String> embeddedMap = new LinkedHashMap<String, String>();
            embeddedMap.put("test-key-1", "value-1");
            embeddedMap.put("test-key-2", "value-2");
            embeddedMap.put("test-key-3", "value-3");
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.testQueueName);
            AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
            message.setApplicationProperty("IntProperty", (Object)42);
            message.setDurable(true);
            message.setMessageAnnotation(annotation, embeddedMap);
            sender.send(message);
            session.close();
            Wait.assertEquals((int)1, () -> this.getMessageCount(this.server.getPostOffice(), this.testQueueName));
            try (org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
                 Connection connection2 = factory.createConnection();){
                Session session2 = connection2.createSession(false, 1);
                connection2.start();
                MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(this.testQueueName));
                Message received = consumer.receive(5000L);
                Assert.assertNotNull((Object)received);
                Assert.assertEquals((long)42L, (long)received.getIntProperty("IntProperty"));
                connection2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAMQPReceiveOpenWire() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), this.testQueueName);
            AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
            this.receiveJMS(nMsgs, (ConnectionFactory)factory);
        }
    }

    private void sendMessages(int nMsgs, AmqpConnection connection) throws Exception {
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.testQueueName);
        for (int i = 0; i < nMsgs; ++i) {
            AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
            message.setApplicationProperty("i", (Object)i);
            message.setDurable(true);
            sender.send(message);
        }
        session.close();
    }

    private void receiveJMS(int nMsgs, ConnectionFactory factory) throws JMSException {
        Connection connection2 = factory.createConnection();
        Session session2 = connection2.createSession(false, 1);
        connection2.start();
        MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(this.testQueueName));
        for (int i = 0; i < nMsgs; ++i) {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty("i"));
        }
        connection2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAMQPReceiveAMQP() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
            AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(nMsgs);
            for (int i = 0; i < nMsgs; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                AmqpLargeMessageTest.assertNotNull((String)("failed at " + i), (Object)message);
                MessageImpl wrapped = (MessageImpl)message.getWrappedMessage();
                if (wrapped.getBody() instanceof Data) {
                    Data data = (Data)wrapped.getBody();
                    this.instanceLog.debug((Object)("received : message: " + data.getValue().getLength()));
                    AmqpLargeMessageTest.assertEquals((long)this.payload, (long)data.getValue().getLength());
                }
                message.accept();
            }
            session.close();
        }
    }

    @Test(timeout=60000L)
    public void testSendAMQPMessageWithComplexAnnotationsReceiveAMQP() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        Symbol annotation = Symbol.valueOf((String)"x-opt-embedded-map");
        LinkedHashMap<String, String> embeddedMap = new LinkedHashMap<String, String>();
        embeddedMap.put("test-key-1", "value-1");
        embeddedMap.put("test-key-2", "value-2");
        embeddedMap.put("test-key-3", "value-3");
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(testQueueName);
        AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
        message.setApplicationProperty("IntProperty", (Object)42);
        message.setDurable(true);
        message.setMessageAnnotation(annotation.toString(), embeddedMap);
        sender.send(message);
        session.close();
        connection.close();
        Wait.assertEquals((int)1, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName));
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(testQueueName);
        receiver.flow(nMsgs);
        message = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpLargeMessageTest.assertNotNull((String)"Failed to read message with embedded map in annotations", (Object)message);
        MessageImpl wrapped = (MessageImpl)message.getWrappedMessage();
        if (wrapped.getBody() instanceof Data) {
            Data data = (Data)wrapped.getBody();
            this.instanceLog.debug((Object)("received : message: " + data.getValue().getLength()));
            AmqpLargeMessageTest.assertEquals((long)this.payload, (long)data.getValue().getLength());
        }
        AmqpLargeMessageTest.assertNotNull((Object)message.getWrappedMessage().getMessageAnnotations());
        AmqpLargeMessageTest.assertNotNull((Object)message.getWrappedMessage().getMessageAnnotations().getValue());
        AmqpLargeMessageTest.assertEquals(embeddedMap, message.getWrappedMessage().getMessageAnnotations().getValue().get(annotation));
        message.accept();
        session.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testHugeString() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        StringBuilder unicodeStringBuilder = new StringBuilder();
        for (char c = '\u03e8'; c < '\u2af8'; c = (char)(c + '\u0001')) {
            unicodeStringBuilder.append(c);
        }
        String unicodeString = unicodeStringBuilder.toString();
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 0x100000) {
            builder.append("hello " + unicodeString);
        }
        producer.send((Message)session.createTextMessage(builder.toString()));
        session.commit();
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage message = (TextMessage)consumer.receive(50000L);
        Assert.assertNotNull((Object)message);
        session.commit();
        Assert.assertEquals((Object)builder.toString(), (Object)message.getText());
    }

    @Test(timeout=60000L)
    public void testSendAMQPReceiveAMQPViaJMSObjectMessage() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendObjectMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    @Test(timeout=60000L)
    public void testSendAMQPReceiveAMQPViaJMSText() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendTextMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    @Test(timeout=60000L)
    public void testSendAMQPReceiveAMQPViaJMSBytes() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendBytesMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        AmqpLargeMessageTest.assertEquals((long)nMsgs, (long)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    private byte[] createLargePayload(int sizeInBytes) {
        byte[] payload = new byte[sizeInBytes];
        for (int i = 0; i < sizeInBytes; ++i) {
            payload[i] = (byte)this.rand.nextInt(256);
        }
        LOG.debug("Created buffer with size : " + sizeInBytes + " bytes");
        return payload;
    }

    @Test(timeout=60000L)
    public void testSendHugeHeader() throws Exception {
        this.doTestSendHugeHeader(this.payload);
    }

    @Test(timeout=60000L)
    public void testSendLargeMessageWithHugeHeader() throws Exception {
        this.doTestSendHugeHeader(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSendHugeHeader(int expectedSize) throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            connection.connect();
            int strLength = 524288;
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.testQueueName);
            AmqpMessage message = this.createAmqpMessage((byte)65, expectedSize);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 524288; ++i) {
                buffer.append(" ");
            }
            message.setApplicationProperty("str", (Object)buffer.toString());
            message.setDurable(true);
            try {
                sender.send(message);
                AmqpLargeMessageTest.fail();
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof JMSException));
                Assert.assertTrue((boolean)e.getMessage().contains("AMQ149005"));
            }
            session.close();
        }
    }

    @Test(timeout=60000L)
    public void testSendSmallerMessages() throws Exception {
        for (int i = 512; i <= 8192; i += 512) {
            this.doTestSendLargeMessage(i);
        }
    }

    @Test(timeout=120000L)
    public void testSendFixedSizedMessages() throws Exception {
        this.doTestSendLargeMessage(65536);
        this.doTestSendLargeMessage(131072);
        this.doTestSendLargeMessage(262144);
    }

    @Test(timeout=120000L)
    public void testSend1MBMessage() throws Exception {
        this.doTestSendLargeMessage(0x100000);
    }

    @Ignore(value="Useful for performance testing")
    @Test(timeout=120000L)
    public void testSend10MBMessage() throws Exception {
        this.doTestSendLargeMessage(0xA00000);
    }

    @Ignore(value="Useful for performance testing")
    @Test(timeout=120000L)
    public void testSend100MBMessage() throws Exception {
        this.doTestSendLargeMessage(0x6400000);
    }

    public void doTestSendLargeMessage(int expectedSize) throws Exception {
        LOG.debug("doTestSendLargeMessage called with expectedSize " + expectedSize);
        byte[] payload = this.createLargePayload(expectedSize);
        AmqpLargeMessageTest.assertEquals((long)expectedSize, (long)payload.length);
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            long startTime = System.currentTimeMillis();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.name.getMethodName());
            MessageProducer producer = session.createProducer((Destination)queue);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(payload);
            producer.setDeliveryMode(1);
            producer.setPriority(4);
            producer.send((Message)message);
            long endTime = System.currentTimeMillis();
            LOG.debug("Returned from send after {} ms", (Object)(endTime - startTime));
            startTime = System.currentTimeMillis();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            LOG.debug("Calling receive");
            Message received = consumer.receive();
            AmqpLargeMessageTest.assertNotNull((Object)received);
            AmqpLargeMessageTest.assertTrue((boolean)(received instanceof BytesMessage));
            BytesMessage bytesMessage = (BytesMessage)received;
            AmqpLargeMessageTest.assertNotNull((Object)bytesMessage);
            endTime = System.currentTimeMillis();
            LOG.debug("Returned from receive after {} ms", (Object)(endTime - startTime));
            byte[] bytesReceived = new byte[expectedSize];
            AmqpLargeMessageTest.assertEquals((long)expectedSize, (long)bytesMessage.readBytes(bytesReceived, expectedSize));
            AmqpLargeMessageTest.assertTrue((boolean)Arrays.equals(payload, bytesReceived));
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReceiveRedeliveredLargeMessagesWithSessionFlowControl() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int numMsgs = 10;
        int msgSize = 2000000;
        int maxFrameSize = this.frameSize;
        int sessionCapacity = 2500000;
        byte[] payload = this.createLargePayload(msgSize);
        AmqpLargeMessageTest.assertEquals((long)msgSize, (long)payload.length);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.setSessionIncomingCapacity(sessionCapacity);
        connection.connect();
        this.addConnection(connection);
        try {
            int i;
            String testQueueName = this.getTestName();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(testQueueName);
            for (int i2 = 0; i2 < numMsgs; ++i2) {
                AmqpMessage message = new AmqpMessage();
                message.setBytes(payload);
                sender.send(message);
            }
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName), (long)5000L, (long)10L);
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(numMsgs);
            ArrayList<AmqpMessage> messages = new ArrayList<AmqpMessage>();
            for (i = 0; i < numMsgs; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                AmqpLargeMessageTest.assertNotNull((String)("failed at " + i), (Object)message);
                messages.add(message);
            }
            for (i = 0; i < numMsgs; ++i) {
                AmqpMessage msg = (AmqpMessage)messages.get(i);
                msg.modified(Boolean.valueOf(true), Boolean.valueOf(false));
            }
            receiver.close();
            AmqpReceiver receiver2 = session.createReceiver(testQueueName);
            receiver2.flow(numMsgs);
            for (int i3 = 0; i3 < numMsgs; ++i3) {
                AmqpMessage message = receiver2.receive(5L, TimeUnit.SECONDS);
                this.validateMessage(payload, i3, message);
                message.accept();
            }
            session.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReceiveLargeMessagesMultiplexedOnSameSession() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int numMsgs = 10;
        int maxFrameSize = this.frameSize;
        int msgSizeA = this.frameSize * 4;
        int msgSizeB = maxFrameSize / 2;
        int sessionCapacity = msgSizeA + maxFrameSize;
        byte[] payloadA = this.createLargePayload(msgSizeA);
        AmqpLargeMessageTest.assertEquals((long)msgSizeA, (long)payloadA.length);
        byte[] payloadB = this.createLargePayload(msgSizeB);
        AmqpLargeMessageTest.assertEquals((long)msgSizeB, (long)payloadB.length);
        String testQueueNameA = this.getTestName() + "A";
        String testQueueNameB = this.getTestName() + "B";
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.setSessionIncomingCapacity(sessionCapacity);
        connection.connect();
        this.addConnection(connection);
        try {
            AmqpSession session = connection.createSession();
            AmqpSender senderA = session.createSender(testQueueNameA);
            AmqpSender senderB = session.createSender(testQueueNameB);
            for (int i = 0; i < numMsgs; ++i) {
                AmqpMessage messageA = new AmqpMessage();
                messageA.setBytes(payloadA);
                senderA.send(messageA);
                AmqpMessage messageB = new AmqpMessage();
                messageB.setBytes(payloadB);
                senderB.send(messageB);
            }
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueNameA), (long)5000L, (long)10L);
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueNameB), (long)5000L, (long)10L);
            AmqpReceiver receiverA = session.createReceiver(testQueueNameA);
            AmqpReceiver receiverB = session.createReceiver(testQueueNameB);
            receiverA.flow(numMsgs / 2, true);
            receiverB.flow(numMsgs / 2);
            receiverA.flow(numMsgs / 2, true);
            receiverB.flow(numMsgs / 2);
            ArrayList<AmqpMessage> messagesA = new ArrayList<AmqpMessage>();
            ArrayList<AmqpMessage> messagesB = new ArrayList<AmqpMessage>();
            long timeout = 6000L;
            long start = System.nanoTime();
            boolean timeRemaining = true;
            while (timeRemaining) {
                if (messagesA.size() < numMsgs) {
                    LOG.debug("Attempting to receive message for receiver A");
                    AmqpMessage messageA = receiverA.receive(20L, TimeUnit.MILLISECONDS);
                    if (messageA != null) {
                        LOG.debug("Got message for receiver A");
                        messagesA.add(messageA);
                        messageA.accept();
                    }
                }
                if (messagesB.size() < numMsgs) {
                    LOG.debug("Attempting to receive message for receiver B");
                    AmqpMessage messageB = receiverB.receive(20L, TimeUnit.MILLISECONDS);
                    if (messageB != null) {
                        LOG.debug("Got message for receiver B");
                        messagesB.add(messageB);
                        messageB.accept();
                    }
                }
                if (messagesA.size() == numMsgs && messagesB.size() == numMsgs) {
                    LOG.debug("Received expected messages");
                    break;
                }
                timeRemaining = System.nanoTime() - start < TimeUnit.MILLISECONDS.toNanos(timeout);
            }
            AmqpLargeMessageTest.assertTrue((String)("Failed to receive all messages in expected time: A=" + messagesA.size() + ", B=" + messagesB.size()), (boolean)timeRemaining);
            AmqpLargeMessageTest.assertNull((String)"Unexpected additional message present for A", (Object)receiverA.receiveNoWait());
            AmqpLargeMessageTest.assertNull((String)"Unexpected additional message present for B", (Object)receiverB.receiveNoWait());
            for (int i = 0; i < numMsgs; ++i) {
                AmqpMessage messageA = (AmqpMessage)messagesA.get(i);
                this.validateMessage(payloadA, i, messageA);
                AmqpMessage messageB = (AmqpMessage)messagesB.get(i);
                this.validateMessage(payloadB, i, messageB);
            }
            receiverA.close();
            receiverB.close();
            session.close();
        }
        finally {
            connection.close();
        }
    }

    private void validateMessage(byte[] expectedPayload, int msgNum, AmqpMessage message) {
        AmqpLargeMessageTest.assertNotNull((String)("failed at " + msgNum), (Object)message);
        Section body = message.getWrappedMessage().getBody();
        AmqpLargeMessageTest.assertNotNull((String)("No message body for msg " + msgNum), (Object)body);
        AmqpLargeMessageTest.assertTrue((String)("Unexpected message body type for msg " + body.getClass()), (boolean)(body instanceof Data));
        AmqpLargeMessageTest.assertEquals((String)"Unexpected body content for msg", (Object)new Binary(expectedPayload, 0, expectedPayload.length), (Object)((Data)body).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMessageWithAmqpValueAndEmptyBinaryPreservesBody() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            message.getWrappedMessage().setBody((Section)new AmqpValue((Object)new Binary(new byte[0])));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpLargeMessageTest.assertNotNull((String)"failed to read large AMQP message", (Object)received);
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            AmqpLargeMessageTest.assertTrue((boolean)(wrapped.getBody() instanceof AmqpValue));
            AmqpValue body = (AmqpValue)wrapped.getBody();
            AmqpLargeMessageTest.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = (Binary)body.getValue();
            AmqpLargeMessageTest.assertEquals((long)0L, (long)payload.getLength());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMessageWithDataAndEmptyBinaryPreservesBody() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            message.getWrappedMessage().setBody((Section)new Data(new Binary(new byte[0])));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpLargeMessageTest.assertNotNull((String)"failed to read large AMQP message", (Object)received);
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            AmqpLargeMessageTest.assertTrue((boolean)(wrapped.getBody() instanceof Data));
            Data body = (Data)wrapped.getBody();
            AmqpLargeMessageTest.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = body.getValue();
            AmqpLargeMessageTest.assertEquals((long)0L, (long)payload.getLength());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMessageWithDataAndContentTypeOfTextPreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            String messageText = "This text will be in a Data Section";
            message.getWrappedMessage().setContentType("text/plain");
            message.getWrappedMessage().setBody((Section)new Data(new Binary(messageText.getBytes(StandardCharsets.UTF_8))));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpLargeMessageTest.assertNotNull((String)"failed to read large AMQP message", (Object)received);
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            AmqpLargeMessageTest.assertTrue((boolean)(wrapped.getBody() instanceof Data));
            Data body = (Data)wrapped.getBody();
            AmqpLargeMessageTest.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = body.getValue();
            String reconstitutedString = new String(payload.getArray(), payload.getArrayOffset(), payload.getLength(), StandardCharsets.UTF_8);
            AmqpLargeMessageTest.assertEquals((Object)messageText, (Object)reconstitutedString);
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMessageWithAmqpValueListPreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            ArrayList<String> values = new ArrayList<String>();
            values.add("1");
            values.add("2");
            values.add("3");
            message.getWrappedMessage().setBody((Section)new AmqpValue(values));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpLargeMessageTest.assertNotNull((String)"failed to read large AMQP message", (Object)received);
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            AmqpLargeMessageTest.assertTrue((boolean)(wrapped.getBody() instanceof AmqpValue));
            AmqpValue body = (AmqpValue)wrapped.getBody();
            AmqpLargeMessageTest.assertTrue((boolean)(body.getValue() instanceof List));
            List payload = (List)body.getValue();
            AmqpLargeMessageTest.assertEquals((long)3L, (long)payload.size());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMessageWithAmqpSequencePreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            ArrayList<String> values = new ArrayList<String>();
            values.add("1");
            values.add("2");
            values.add("3");
            message.getWrappedMessage().setBody((Section)new AmqpSequence(values));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpLargeMessageTest.assertNotNull((String)"failed to read large AMQP message", (Object)received);
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            AmqpLargeMessageTest.assertTrue((boolean)(wrapped.getBody() instanceof AmqpSequence));
            AmqpSequence body = (AmqpSequence)wrapped.getBody();
            AmqpLargeMessageTest.assertTrue((boolean)(body.getValue() instanceof List));
            List payload = body.getValue();
            AmqpLargeMessageTest.assertEquals((long)3L, (long)payload.size());
            received.accept();
            session.close();
        }
    }

    private void sendObjectMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            ObjectMessage msg = session.createObjectMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.setObject((Serializable)((Object)builder.toString()));
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private void sendTextMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage msg = session.createTextMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.setText(builder.toString());
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private void sendBytesMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            BytesMessage msg = session.createBytesMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.writeBytes(builder.toString().getBytes(StandardCharsets.UTF_8));
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private AmqpMessage createAmqpMessage(byte value, int payloadSize) {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[payloadSize];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = value;
        }
        message.setBytes(payload);
        return message;
    }

    private AmqpMessage createAmqpLargeMessageWithNoBody() {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[524288];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 65;
        }
        message.setMessageAnnotation("x-opt-big-blob", (Object)new String(payload, StandardCharsets.UTF_8));
        return message;
    }
}

