/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.RoaringDocIdSet;
import org.hibernate.search.util.impl.SoftLimitMRUCache;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CachingWrapperQuery
extends Query
implements Cloneable {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    public static final int DEFAULT_SIZE = 5;
    private static final int HARD_TO_SOFT_RATIO = 15;
    private Query query;
    private final SoftLimitMRUCache cache;

    public CachingWrapperQuery(Query query) {
        this(query, 5);
    }

    public CachingWrapperQuery(Query query, int size) {
        this.query = query;
        int softRefSize = size * 15;
        if (log.isDebugEnabled()) {
            log.debugf("Initialising SoftLimitMRUCache with hard ref size of %d and a soft ref of %d", size, softRefSize);
        }
        this.cache = new SoftLimitMRUCache(size, softRefSize);
    }

    public Query getQuery() {
        return this.query;
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader) throws IOException {
        return new RoaringDocIdSet.Builder(reader.maxDoc()).add(iterator).build();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query rewritten = this.query.rewrite(reader);
        if (this.query == rewritten) {
            return super.rewrite(reader);
        }
        CachingWrapperQuery clone = (CachingWrapperQuery)this.clone();
        clone.query = rewritten;
        return clone;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        if (needsScores) {
            return weight;
        }
        return new ConstantScoreWeight(weight.getQuery()){

            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet docIdSet = this.getDocIdSet(context);
                assert (docIdSet != null);
                if (docIdSet == DocIdSet.EMPTY) {
                    return null;
                }
                DocIdSetIterator disi = docIdSet.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, disi);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                Object key = reader.getCoreCacheKey();
                Object cached = CachingWrapperQuery.this.cache.get(key);
                if (cached != null) {
                    return (DocIdSet)cached;
                }
                SoftLimitMRUCache softLimitMRUCache = CachingWrapperQuery.this.cache;
                synchronized (softLimitMRUCache) {
                    cached = CachingWrapperQuery.this.cache.get(key);
                    if (cached != null) {
                        return (DocIdSet)cached;
                    }
                    Scorer scorer = weight.scorer(context);
                    DocIdSet docIdSet = scorer == null ? DocIdSet.EMPTY : CachingWrapperQuery.this.cacheImpl(scorer.iterator(), reader);
                    CachingWrapperQuery.this.cache.put(key, docIdSet);
                    return docIdSet;
                }
            }
        };
    }

    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.query.toString(field) + ")";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CachingWrapperQuery other = (CachingWrapperQuery)o;
        return this.query.equals((Object)other.query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ super.hashCode();
    }
}

