/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.AsyncDelay;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.Executor;

public class TimerDelay
implements AsyncDelay {
    private final BackOff backOff;
    private final Timer timer;

    public TimerDelay(BackOff backOff, Timer timer) {
        this.backOff = Preconditions.checkNotNull(backOff, "Back-off must be set");
        this.timer = Preconditions.checkNotNull(timer, "Timer must be set");
    }

    @Override
    public void after(Throwable cause, Runnable task, Executor executor) {
        long delay = this.backOff.getInMillis(cause);
        if (delay > 0L) {
            this.timer.schedule(delay, task, executor);
        } else {
            task.run();
        }
    }
}

