/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token.validator;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.json.util.JsonUtil;

public class OAuth2IntrospectValidator
implements TokenValidator {
    private final URL tokenIntrospectionUrl;
    private final String clientId;
    private final String clientSecret;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final int connectionTimeout;
    private final int readTimeout;

    public static Builder builder() {
        return new Builder();
    }

    OAuth2IntrospectValidator(Builder configuration) {
        this.tokenIntrospectionUrl = (URL)Assert.checkNotNullParam((String)"tokenIntrospectionUrl", (Object)configuration.tokenIntrospectionUrl);
        this.clientId = (String)Assert.checkNotNullParam((String)"clientId", (Object)configuration.clientId);
        this.clientSecret = (String)Assert.checkNotNullParam((String)"clientSecret", (Object)configuration.clientSecret);
        if (this.tokenIntrospectionUrl.getProtocol().equalsIgnoreCase("https")) {
            Assert.checkNotNullParam((String)"sslContext", (Object)configuration.sslContext);
        }
        this.sslContext = configuration.sslContext;
        this.hostnameVerifier = configuration.hostnameVerifier;
        this.connectionTimeout = configuration.connectionTimeout;
        this.readTimeout = configuration.readTimeout;
    }

    @Override
    public Attributes validate(BearerTokenEvidence evidence) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        try {
            JsonObject claims = this.introspectAccessToken(this.tokenIntrospectionUrl, this.clientId, this.clientSecret, evidence.getToken(), this.sslContext, this.hostnameVerifier);
            if (this.isValidToken(claims)) {
                return JsonUtil.toAttributes((JsonObject)claims);
            }
        }
        catch (Exception e) {
            throw ElytronMessages.log.tokenRealmOAuth2TokenIntrospectionFailed(e);
        }
        return null;
    }

    private boolean isValidToken(JsonObject claims) {
        return claims != null && claims.getBoolean("active", false);
    }

    private JsonObject introspectAccessToken(URL tokenIntrospectionUrl, String clientId, String clientSecret, String token, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws RealmUnavailableException {
        block23: {
            JsonObject jsonObject;
            Assert.checkNotNullParam((String)"clientId", (Object)clientId);
            Assert.checkNotNullParam((String)"clientSecret", (Object)clientSecret);
            Assert.checkNotNullParam((String)"token", (Object)token);
            HttpURLConnection connection = null;
            connection = this.openConnection(tokenIntrospectionUrl, sslContext, hostnameVerifier);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("token", token);
            parameters.put("token_type_hint", "access_token");
            byte[] params = this.buildParameters(parameters);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", String.valueOf(params.length));
            connection.setRequestProperty("Authorization", "Basic " + CodePointIterator.ofString((String)(clientId + ":" + clientSecret)).asUtf8().base64Encode().drainToString());
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(params);
            }
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            try {
                jsonObject = Json.createReader((InputStream)inputStream).readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    if (connection != null && connection.getErrorStream() != null) {
                        InputStream errorStream = connection.getErrorStream();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
                            StringBuffer response = reader.lines().reduce(new StringBuffer(), StringBuffer::append, (buffer1, buffer2) -> buffer1);
                            ElytronMessages.log.errorf(ioe, "Unexpected response from token introspection endpoint [%s]. Response: [%s]", tokenIntrospectionUrl, response);
                            break block23;
                        }
                        catch (IOException e) {
                            throw ElytronMessages.log.tokenRealmOAuth2TokenIntrospectionFailed(ioe);
                        }
                    }
                    throw ElytronMessages.log.tokenRealmOAuth2TokenIntrospectionFailed(ioe);
                }
                catch (Exception e) {
                    throw ElytronMessages.log.tokenRealmOAuth2TokenIntrospectionFailed(e);
                }
            }
            ((InputStream)inputStream).close();
            return jsonObject;
        }
        return null;
    }

    private HttpURLConnection openConnection(URL url, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
        Assert.checkNotNullParam((String)"url", (Object)url);
        boolean isHttps = url.getProtocol().equalsIgnoreCase("https");
        ElytronMessages.log.debugf("Opening connection to token introspection endpoint [%s]", url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (isHttps) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(sslContext.getSocketFactory());
            if (hostnameVerifier != null) {
                https.setHostnameVerifier(hostnameVerifier);
            }
        }
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        return connection;
    }

    private byte[] buildParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
        ByteStringBuilder params = new ByteStringBuilder();
        parameters.entrySet().stream().forEach(entry -> {
            if (params.length() > 0) {
                params.append('&');
            }
            params.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        });
        return params.toArray();
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private URL tokenIntrospectionUrl;
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private int connectionTimeout;
        private int readTimeout;

        private Builder() {
        }

        public Builder tokenIntrospectionUrl(URL url) {
            this.tokenIntrospectionUrl = url;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder useSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder useSslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public OAuth2IntrospectValidator build() {
            return new OAuth2IntrospectValidator(this);
        }
    }
}

