/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadAttributeGroupHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute-group", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.INCLUDE_RUNTIME, GlobalOperationAttributes.INCLUDE_DEFAULTS, GlobalOperationAttributes.INCLUDE_ALIASES).setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.PROPERTY).build();
    private static final SimpleAttributeDefinition RESOLVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resolve-expressions", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    public static final OperationDefinition RESOLVE_DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute-group", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, RESOLVE, GlobalOperationAttributes.INCLUDE_RUNTIME, GlobalOperationAttributes.INCLUDE_DEFAULTS, GlobalOperationAttributes.INCLUDE_ALIASES).setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.PROPERTY).build();
    static OperationStepHandler INSTANCE = new ReadAttributeGroupHandler();
    public static OperationStepHandler RESOLVE_INSTANCE = new ReadAttributeGroupHandler(true);
    private final ParametersValidator validator = new ParametersValidator(){

        @Override
        public void validate(ModelNode operation) throws OperationFailedException {
            super.validate(operation);
            for (AttributeDefinition def : DEFINITION.getParameters()) {
                def.validateOperation(operation);
            }
            if (operation.hasDefined("resolve-expressions") && operation.get("resolve-expressions").asBoolean(false) && !ReadAttributeGroupHandler.this.resolvable) {
                throw ControllerLogger.ROOT_LOGGER.unableToResolveExpressions();
            }
        }
    };
    private final boolean resolvable;

    public ReadAttributeGroupHandler() {
        this(false);
    }

    public ReadAttributeGroupHandler(boolean resolvable) {
        this.resolvable = resolvable;
    }

    private void addReadAttributeStep(OperationContext context, PathAddress address, boolean defaults, boolean resolve, FilteredData localFilteredData, ImmutableManagementResourceRegistration registry, AttributeDefinition.NameAndGroup attributeKey, Map<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> responseMap) {
        OperationStepHandler overrideHandler = registry.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-attribute");
        if (overrideHandler != null && (overrideHandler == ReadAttributeHandler.INSTANCE || overrideHandler == ReadAttributeHandler.RESOLVE_INSTANCE)) {
            overrideHandler = null;
        }
        ReadAttributeHandler readAttributeHandler = new ReadAttributeHandler(localFilteredData, overrideHandler, resolve && this.resolvable);
        ModelNode attributeOperation = Util.getReadAttributeOperation(address, attributeKey.getName());
        attributeOperation.get("include-defaults").set(defaults);
        attributeOperation.get("resolve-expressions").set(resolve);
        ModelNode attrResponse = new ModelNode();
        GlobalOperationHandlers.AvailableResponse availableResponse = new GlobalOperationHandlers.AvailableResponse(attrResponse);
        responseMap.put(attributeKey, availableResponse);
        GlobalOperationHandlers.AvailableResponseWrapper wrapper = new GlobalOperationHandlers.AvailableResponseWrapper(readAttributeHandler, availableResponse);
        context.addStep(attrResponse, attributeOperation, wrapper, OperationContext.Stage.MODEL, true);
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResource) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = context.getCurrentAddress();
        boolean includeRutime = operation.get("include-runtime").asBoolean(false);
        boolean aliases = operation.get("include-aliases").asBoolean(false);
        boolean defaults = operation.get("include-defaults").asBoolean(true);
        boolean resolve = RESOLVE.resolveModelAttribute(context, operation).asBoolean();
        ModelNode groupNameNode = GlobalOperationAttributes.NAME.resolveModelAttribute(context, operation);
        String groupName = groupNameNode.isDefined() ? groupNameNode.asString() : null;
        FilteredData localFilteredData = new FilteredData(address);
        HashMap<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> metrics = includeRutime ? new HashMap<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse>() : Collections.emptyMap();
        HashMap otherAttributes = new HashMap();
        ReadAttributeGroupAssemblyHandler assemblyHandler = new ReadAttributeGroupAssemblyHandler(metrics, otherAttributes, filteredData, ignoreMissingResource);
        context.addStep(assemblyHandler, includeRutime ? OperationContext.Stage.VERIFY : OperationContext.Stage.MODEL, true);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Set<String> attributeNames = registry != null ? registry.getAttributeNames(PathAddress.EMPTY_ADDRESS) : Collections.emptySet();
        for (String attributeName : attributeNames) {
            AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            AttributeDefinition ad = access.getAttributeDefinition();
            if (!aliases && access.getFlags().contains((Object)AttributeAccess.Flag.ALIAS) || !includeRutime && access.getStorageType() != AttributeAccess.Storage.CONFIGURATION || groupName != null && !groupName.equals(ad.getAttributeGroup())) continue;
            HashMap<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> responseMap = access.getAccessType() == AttributeAccess.AccessType.METRIC ? metrics : otherAttributes;
            AttributeDefinition.NameAndGroup nag = ad == null ? new AttributeDefinition.NameAndGroup(attributeName) : new AttributeDefinition.NameAndGroup(ad);
            this.addReadAttributeStep(context, address, defaults, resolve, localFilteredData, registry, nag, responseMap);
        }
    }

    private static class ReadAttributeGroupAssemblyHandler
    implements OperationStepHandler {
        private final Map<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> metrics;
        private final Map<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> otherAttributes;
        private final FilteredData filteredData;
        private final boolean ignoreMissingResource;

        private ReadAttributeGroupAssemblyHandler(Map<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> metrics, Map<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> otherAttributes, FilteredData filteredData, boolean ignoreMissingResource) {
            this.metrics = metrics;
            this.otherAttributes = otherAttributes;
            this.filteredData = filteredData;
            this.ignoreMissingResource = ignoreMissingResource;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value;
            GlobalOperationHandlers.AvailableResponse ar;
            TreeMap<AttributeDefinition.NameAndGroup, ModelNode> sortedAttributes = new TreeMap<AttributeDefinition.NameAndGroup, ModelNode>();
            boolean failed = false;
            for (Map.Entry<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> entry : this.otherAttributes.entrySet()) {
                ar = entry.getValue();
                if (ar.unavailable) {
                    this.handleMissingResource(context);
                    return;
                }
                value = ar.response;
                if (!value.has("failure-description")) {
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                failed = true;
                break;
            }
            if (!failed) {
                for (Map.Entry<AttributeDefinition.NameAndGroup, GlobalOperationHandlers.AvailableResponse> metric : this.metrics.entrySet()) {
                    ar = metric.getValue();
                    if (ar.unavailable) {
                        this.handleMissingResource(context);
                        return;
                    }
                    value = ar.response;
                    if (value.has("failure-description")) continue;
                    sortedAttributes.put(metric.getKey(), value.get("result"));
                }
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : sortedAttributes.entrySet()) {
                    result.get(((AttributeDefinition.NameAndGroup)entry.getKey()).getName()).set((ModelNode)entry.getValue());
                }
                if (this.filteredData != null && this.filteredData.hasFilteredData()) {
                    context.getResponseHeaders().get("access-control").set(this.filteredData.toModelNode());
                }
            }
        }

        private void handleMissingResource(OperationContext context) {
            if (context.hasResult()) {
                context.getResult().set(new ModelNode());
            }
            if (!this.ignoreMissingResource) {
                throw ControllerLogger.MGMT_OP_LOGGER.managementResourceNotFound(context.getCurrentAddress());
            }
        }
    }
}

