/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.resteasy.jose.jws.Algorithm;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWSHeader
implements Serializable {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWSHeader() {
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType, String keyId) {
        this.algorithm = algorithm;
        this.type = type;
        this.keyId = keyId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    @JsonIgnore
    public MediaType getMediaType() {
        if (this.contentType == null) {
            return null;
        }
        return MediaType.valueOf((String)this.contentType);
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

