/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.i18n;

import io.smallrye.reactive.messaging.wiring.Wiring;
import jakarta.enterprise.inject.spi.Bean;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;

@MessageLogger(projectCode="SRMSG", length=5)
public interface ProviderLogging
extends BasicLogger {
    public static final ProviderLogging log = (ProviderLogging)Logger.getMessageLogger(ProviderLogging.class, (String)"io.smallrye.reactive.messaging.provider");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200, value="The method %s has thrown an exception")
    public void methodException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=201, value="Error caught while processing a message")
    public void messageProcessingException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=202, value="Created new Vertx instance")
    public void vertXInstanceCreated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=203, value="Created worker pool named %s with concurrency of %d")
    public void workerPoolCreated(String var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=204, value="Multiple publisher found for %s, using the merge policy `ONE` takes the first found")
    public void multiplePublisherFound(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=205, value="Strict mode enabled")
    public void strictModeEnabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=206, value="Scanning Type: %s")
    public void scanningType(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=207, value="%s")
    public void reportWiringFailures(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=208, value="The connector '%s' has no downstreams")
    public void connectorWithoutDownstream(Wiring.Component var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=209, value="Beginning graph resolution, number of components detected: %d")
    public void startGraphResolution(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=210, value="Graph resolution completed in %d ns")
    public void completedGraphResolution(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=211, value="Unable to create invoker instance of %s")
    public void unableToCreateInvoker(Class<?> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=212, value="Unable to initialize mediator: %s")
    public void unableToInitializeMediator(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=224, value="Analyzing mediator bean: %s")
    public void analyzingMediatorBean(Bean<?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=226, value="Found incoming connectors: %s")
    public void foundIncomingConnectors(List<String> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=227, value="Found outgoing connectors: %s")
    public void foundOutgoingConnectors(List<String> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=228, value="No MicroProfile Config found, skipping")
    public void skippingMPConfig();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=229, value="Channel manager initializing...")
    public void channelManagerInitializing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=230, value="Unable to create the publisher or subscriber during initialization")
    public void unableToCreatePublisherOrSubscriber(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=231, value="Incoming channel `%s` disabled by configuration")
    public void incomingChannelDisabled(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=232, value="Outgoing channel `%s` disabled by configuration")
    public void outgoingChannelDisabled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=233, value="Unable to extract the ingested payload type for method `%s`, the reason is: %s")
    public void unableToExtractIngestedPayloadType(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=234, value="Failed to emit a Message to the channel")
    public void failureEmittingMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=235, value="Beginning materialization")
    public void startMaterialization();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=236, value="Materialization completed in %d ns")
    public void materializationCompleted(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=237, value="Use of @javax.inject.Named in Reactive Messaging is deprecated, use @io.smallrye.common.annotation.Identifier instead")
    @Once
    public void deprecatedNamed();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=238, value="No ExecutionHolder, disabling @Blocking support")
    public void noExecutionHolderDisablingBlockingSupport();
}

