/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.behavior;

import jakarta.faces.application.Application;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AjaxBehaviors
implements Serializable {
    private static final long serialVersionUID = 1617682489423771119L;
    private static final String AJAX_BEHAVIORS = "jakarta.faces.component.AjaxBehaviors";
    private ArrayDeque<BehaviorInfo> behaviorStack = new ArrayDeque();

    public static AjaxBehaviors getAjaxBehaviors(FacesContext context, boolean createIfNull) {
        Map attrs = context.getAttributes();
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)attrs.get(AJAX_BEHAVIORS);
        if (ajaxBehaviors == null && createIfNull) {
            ajaxBehaviors = new AjaxBehaviors();
            attrs.put(AJAX_BEHAVIORS, ajaxBehaviors);
        }
        return ajaxBehaviors;
    }

    public void addBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        Iterator<BehaviorInfo> descendingIter = this.behaviorStack.descendingIterator();
        while (descendingIter.hasNext()) {
            descendingIter.next().addBehavior(context, behaviorHolder);
        }
    }

    public void pushBehavior(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
        this.behaviorStack.add(new BehaviorInfo(context, ajaxBehavior, eventName));
    }

    public void popBehavior() {
        if (this.behaviorStack.size() > 0) {
            this.behaviorStack.removeLast();
        }
    }

    public static class BehaviorInfo
    implements Serializable {
        private String eventName;
        private Object behaviorState;
        private static final long serialVersionUID = -7679229822647712959L;

        public BehaviorInfo(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
            this.eventName = eventName;
            this.behaviorState = ajaxBehavior.saveState(context);
        }

        public void addBehavior(FacesContext context, ClientBehaviorHolder behaviorHolder) {
            String myEventName = this.eventName;
            if (myEventName == null && (myEventName = behaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(behaviorHolder, myEventName)) {
                ClientBehavior behavior = this.createBehavior(context);
                behaviorHolder.addClientBehavior(myEventName, behavior);
            }
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder behaviorHolder, String eventName) {
            if (!behaviorHolder.getEventNames().contains(eventName)) {
                return false;
            }
            Map allBehaviors = behaviorHolder.getClientBehaviors();
            List eventBehaviors = (List)allBehaviors.get(eventName);
            if (eventBehaviors == null || eventBehaviors.isEmpty()) {
                return true;
            }
            for (ClientBehavior behavior : eventBehaviors) {
                Set hints = behavior.getHints();
                if (!hints.contains(ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext context) {
            Application application = context.getApplication();
            AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("jakarta.faces.behavior.Ajax");
            behavior.restoreState(context, this.behaviorState);
            return behavior;
        }

        private BehaviorInfo() {
        }
    }
}

