/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.WebConfiguration;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FaceletsConfiguration {
    public static final String FACELETS_CONFIGURATION_ATTRIBUTE_NAME = "com.sun.faces.config.FaceletsConfiguration";
    private static final String ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME = "com.sun.faces.config.EscapeInlineText";
    private static Pattern EXTENSION_PATTERN = Pattern.compile("\\.[^/]+$");
    private WebConfiguration config;
    private Map<String, String> faceletsProcessingMappings;

    public FaceletsConfiguration(WebConfiguration config) {
        this.config = config;
        this.faceletsProcessingMappings = config.getFacesConfigOptionValue(WebConfiguration.WebContextInitParameter.FaceletsProcessingFileExtensionProcessAs);
    }

    public boolean isProcessCurrentDocumentAsFaceletsXhtml(String alias) {
        boolean currentModeIsXhtml = true;
        String extension = FaceletsConfiguration.getExtension(alias);
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            currentModeIsXhtml = value.equals("xhtml");
        }
        return currentModeIsXhtml;
    }

    public boolean isOutputHtml5Doctype(String alias) {
        boolean currentModeIsHtml5 = true;
        String extension = FaceletsConfiguration.getExtension(alias);
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            currentModeIsHtml5 = value.equals("html5");
        }
        return currentModeIsHtml5;
    }

    public boolean isConsumeComments(String alias) {
        boolean consumeComments = false;
        String extension = FaceletsConfiguration.getExtension(alias);
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            consumeComments = value.equals("xml") || value.equals("jspx");
        }
        return consumeComments;
    }

    public boolean isConsumeCDATA(String alias) {
        boolean consumeCDATA = false;
        String extension = FaceletsConfiguration.getExtension(alias);
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            consumeCDATA = value.equals("jspx") || value.equals("xml");
        }
        return consumeCDATA;
    }

    public boolean isEscapeInlineText(FacesContext context) {
        Boolean result = Boolean.TRUE;
        result = (Boolean)context.getAttributes().get(ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME);
        if (null == result) {
            String value;
            String extension = FaceletsConfiguration.getExtension(context.getViewRoot().getViewId());
            assert (null != this.faceletsProcessingMappings);
            result = this.faceletsProcessingMappings.containsKey(extension) ? Boolean.valueOf((value = this.faceletsProcessingMappings.get(extension)).equals("xml") || value.equals("xhtml")) : Boolean.TRUE;
            context.getAttributes().put(ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    public static FaceletsConfiguration getInstance(FacesContext context) {
        FaceletsConfiguration result = null;
        Map attrs = context.getAttributes();
        result = (FaceletsConfiguration)attrs.get(FACELETS_CONFIGURATION_ATTRIBUTE_NAME);
        if (null == result) {
            WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
            result = config.getFaceletsConfiguration();
            attrs.put(FACELETS_CONFIGURATION_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    public static FaceletsConfiguration getInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return FaceletsConfiguration.getInstance(context);
    }

    private static String getExtension(String alias) {
        Matcher matcher;
        String ext = null;
        if (alias != null && (matcher = EXTENSION_PATTERN.matcher(alias)).find()) {
            ext = alias.substring(matcher.start(), matcher.end());
        }
        return ext == null ? "xhtml" : ext;
    }
}

