/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.KeyStoreConfiguration;
import org.infinispan.persistence.remote.configuration.TrustStoreConfiguration;

public class SslConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false, Boolean.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<SSLContext> SSL_CONTEXT = AttributeDefinition.builder((String)"sslContext", null, SSLContext.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SNI_HOSTNAME = AttributeDefinition.builder((String)"sniHostname", null, String.class).immutable().build();
    static final AttributeDefinition<String> PROTOCOL = AttributeDefinition.builder((String)"protocol", null, String.class).immutable().build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENCRYPTION.getLocalName());
    private final AttributeSet attributes;
    private KeyStoreConfiguration keyStoreConfiguration;
    private TrustStoreConfiguration trustStoreConfiguration;
    private List<ConfigurationInfo> subElements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SslConfiguration.class, new AttributeDefinition[]{ENABLED, SNI_HOSTNAME, PROTOCOL});
    }

    SslConfiguration(AttributeSet attributes, KeyStoreConfiguration keyStoreConfiguration, TrustStoreConfiguration trustStoreConfiguration) {
        this.attributes = attributes.checkProtection();
        this.keyStoreConfiguration = keyStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.subElements = Arrays.asList(keyStoreConfiguration, trustStoreConfiguration);
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public KeyStoreConfiguration keyStoreConfiguration() {
        return this.keyStoreConfiguration;
    }

    public TrustStoreConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String keyStoreFileName() {
        return this.keyStoreConfiguration.keyStoreFileName();
    }

    public String keyStoreType() {
        return this.keyStoreConfiguration.keyStoreType();
    }

    public char[] keyStorePassword() {
        return this.keyStoreConfiguration.keyStorePassword();
    }

    public char[] keyStoreCertificatePassword() {
        return this.keyStoreConfiguration.keyStoreCertificatePassword();
    }

    public String keyAlias() {
        return this.keyStoreConfiguration.keyAlias();
    }

    public SSLContext sslContext() {
        return (SSLContext)this.attributes.attribute(SSL_CONTEXT).get();
    }

    public String trustStoreFileName() {
        return this.trustStoreConfiguration.trustStoreFileName();
    }

    public String trustStoreType() {
        return this.trustStoreConfiguration.trustStoreType();
    }

    public char[] trustStorePassword() {
        return this.trustStoreConfiguration.trustStorePassword();
    }

    public String sniHostName() {
        return (String)this.attributes.attribute(SNI_HOSTNAME).get();
    }

    public String protocol() {
        return (String)this.attributes.attribute(PROTOCOL).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfiguration that = (SslConfiguration)o;
        if (this.attributes != null ? !this.attributes.equals((Object)that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.keyStoreConfiguration != null ? !this.keyStoreConfiguration.equals(that.keyStoreConfiguration) : that.keyStoreConfiguration != null) {
            return false;
        }
        return this.trustStoreConfiguration != null ? this.trustStoreConfiguration.equals(that.trustStoreConfiguration) : that.trustStoreConfiguration == null;
    }

    public int hashCode() {
        int result = this.attributes != null ? this.attributes.hashCode() : 0;
        result = 31 * result + (this.keyStoreConfiguration != null ? this.keyStoreConfiguration.hashCode() : 0);
        result = 31 * result + (this.trustStoreConfiguration != null ? this.trustStoreConfiguration.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SslConfiguration{attributes=" + this.attributes + ", keyStoreConfiguration=" + this.keyStoreConfiguration + ", trustStoreConfiguration=" + this.trustStoreConfiguration + '}';
    }
}

