/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.Assert;
import org.junit.Test;

public class MqttClusterWildcardTest
extends ClusterTestBase {
    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    public boolean isNetty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadBalanceRequests() throws Exception {
        Object[] topics;
        String TOPIC = "test/+/some/#";
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setAnyWords('#');
        wildcardConfiguration.setDelimiter('/');
        wildcardConfiguration.setRoutingEnabled(true);
        wildcardConfiguration.setSingleWord('+');
        this.setupServer(0, false, this.isNetty());
        this.servers[0].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.setupServer(1, false, this.isNetty());
        this.servers[1].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            connection1 = MqttClusterWildcardTest.retrieveMQTTConnection("tcp://localhost:61616");
            connection2 = MqttClusterWildcardTest.retrieveMQTTConnection("tcp://localhost:61617");
            topics = new Topic[]{new Topic("test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1.subscribe(topics);
            connection2.subscribe(topics);
            this.waitForBindings(0, "test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "test/+/some/#", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            Message message2 = connection1.receive(5L, TimeUnit.SECONDS);
            Message message3 = connection1.receive(5L, TimeUnit.SECONDS);
            Message message4 = connection2.receive(5L, TimeUnit.SECONDS);
            Message message5 = connection2.receive(5L, TimeUnit.SECONDS);
            Message message6 = connection2.receive(5L, TimeUnit.SECONDS);
            MqttClusterWildcardTest.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload1, (Object)new String(message4.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload2, (Object)new String(message5.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload3, (Object)new String(message6.getPayload()));
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"test/+/some/#"};
            if (connection1 != null) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"test/+/some/#"};
        if (connection1 != null) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wildcardsWithBroker1Disconnected() throws Exception {
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        String TOPIC = "test/+/some/#";
        try {
            WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
            wildcardConfiguration.setAnyWords('#');
            wildcardConfiguration.setDelimiter('/');
            wildcardConfiguration.setRoutingEnabled(true);
            wildcardConfiguration.setSingleWord('+');
            this.setupServer(0, false, this.isNetty());
            this.servers[0].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
            this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
            this.startServers(0);
            connection1 = MqttClusterWildcardTest.retrieveMQTTConnection("tcp://localhost:61616");
            Topic[] topics = new Topic[]{new Topic("test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1.subscribe(topics);
            this.waitForBindings(0, "test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "test/+/some/#", 0, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            this.setupServer(1, false, this.isNetty());
            this.servers[1].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
            this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
            this.startServers(1);
            connection2 = MqttClusterWildcardTest.retrieveMQTTConnection("tcp://localhost:61617");
            connection2.subscribe(topics);
            this.waitForBindings(1, "test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "test/+/some/#", 1, 1, false);
            this.waitForBindings(0, "test/+/some/#", 1, 1, true);
            connection1.publish("test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message2 = connection1.receive(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)message2);
            Message message3 = connection1.receive(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)message3);
            Message message4 = connection2.receive(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)message4);
            Message message5 = connection2.receive(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)message5);
            Message message6 = connection2.receive(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)message6);
            MqttClusterWildcardTest.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload1, (Object)new String(message4.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload2, (Object)new String(message5.getPayload()));
            MqttClusterWildcardTest.assertEquals((Object)payload3, (Object)new String(message6.getPayload()));
        }
        catch (Throwable throwable) {
            String[] topics = new String[]{"test/+/some/#"};
            if (connection1 != null) {
                connection1.unsubscribe(topics);
                connection1.disconnect();
            }
            if (connection2 != null) {
                connection2.unsubscribe(topics);
                connection2.disconnect();
            }
            throw throwable;
        }
        String[] topics = new String[]{"test/+/some/#"};
        if (connection1 != null) {
            connection1.unsubscribe(topics);
            connection1.disconnect();
        }
        if (connection2 != null) {
            connection2.unsubscribe(topics);
            connection2.disconnect();
        }
    }

    private static BlockingConnection retrieveMQTTConnection(String host) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setHost(host);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        return connection;
    }
}

