/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.UUID;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataImporter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.unit.util.InVMContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XmlImportExportTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(XmlImportExportTest.class);
    private boolean forceLongs;
    public static final int CONSUMER_TIMEOUT = 5000;
    private static final String QUEUE_NAME = "A1";
    private ServerLocator locator;
    private ActiveMQServer server;
    private JMSServerManager jmsServer;
    private ClientSessionFactory factory;
    private InVMContext namingContext;

    @Parameterized.Parameters(name="forceLongs={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public XmlImportExportTest(boolean forceLongs) {
        this.forceLongs = forceLongs;
    }

    protected void checkForLongs() {
        if (this.forceLongs) {
            JournalStorageManager manager = (JournalStorageManager)this.server.getStorageManager();
            BatchingIDGenerator idGenerator = (BatchingIDGenerator)manager.getIDGenerator();
            idGenerator.forceNextID(0x80000000L);
        }
    }

    @Test
    public void testMessageProperties() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        StringBuilder international = new StringBuilder();
        for (char x = '\u0320'; x < '\u04b0'; x = (char)(x + '\u0001')) {
            international.append(x);
        }
        String special = "\"<>'&";
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeString("Bob the giant pig " + i);
            msg.putBooleanProperty("myBooleanProperty", Boolean.TRUE.booleanValue());
            msg.putByteProperty("myByteProperty", Byte.valueOf("0").byteValue());
            msg.putBytesProperty("myBytesProperty", new byte[]{0, 1, 2, 3, 4});
            msg.putDoubleProperty("myDoubleProperty", (double)i * 1.6);
            msg.putFloatProperty("myFloatProperty", (float)i * 2.5f);
            msg.putIntProperty("myIntProperty", i);
            msg.putLongProperty("myLongProperty", Long.MAX_VALUE - (long)i);
            msg.putObjectProperty("myObjectProperty", (Object)i);
            msg.putObjectProperty("myNullObjectProperty", null);
            msg.putShortProperty("myShortProperty", Integer.valueOf(i).shortValue());
            msg.putStringProperty("myStringProperty", "myStringPropertyValue_" + i);
            msg.putStringProperty("myNullStringProperty", null);
            msg.putStringProperty("myNonAsciiStringProperty", international.toString());
            msg.putStringProperty("mySpecialCharacters", special);
            msg.putStringProperty(new SimpleString("mySimpleStringProperty"), new SimpleString("mySimpleStringPropertyValue_" + i));
            msg.putStringProperty(new SimpleString("myNullSimpleStringProperty"), (SimpleString)null);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            byte[] body = new byte[msg.getBodySize()];
            msg.getBodyBuffer().readBytes(body);
            XmlImportExportTest.assertTrue((boolean)new String(body).contains("Bob the giant pig " + i));
            XmlImportExportTest.assertEquals((Object)msg.getBooleanProperty("myBooleanProperty"), (Object)Boolean.TRUE);
            XmlImportExportTest.assertEquals((Object)msg.getByteProperty("myByteProperty"), (Object)Byte.valueOf("0"));
            byte[] bytes = msg.getBytesProperty("myBytesProperty");
            for (int j = 0; j < 5; ++j) {
                XmlImportExportTest.assertEquals((long)j, (long)bytes[j]);
            }
            XmlImportExportTest.assertEquals((double)((double)i * 1.6), (double)msg.getDoubleProperty("myDoubleProperty"), (double)1.0E-6);
            XmlImportExportTest.assertEquals((double)((float)i * 2.5f), (double)msg.getFloatProperty("myFloatProperty").floatValue(), (double)1.0E-6);
            XmlImportExportTest.assertEquals((long)i, (long)msg.getIntProperty("myIntProperty").intValue());
            XmlImportExportTest.assertEquals((long)(Long.MAX_VALUE - (long)i), (long)msg.getLongProperty("myLongProperty"));
            XmlImportExportTest.assertEquals((Object)i, (Object)msg.getObjectProperty("myObjectProperty"));
            XmlImportExportTest.assertEquals((Object)true, (Object)msg.getPropertyNames().contains(SimpleString.toSimpleString((String)"myNullObjectProperty")));
            XmlImportExportTest.assertEquals(null, (Object)msg.getObjectProperty("myNullObjectProperty"));
            XmlImportExportTest.assertEquals((long)Integer.valueOf(i).shortValue(), (long)msg.getShortProperty("myShortProperty").shortValue());
            XmlImportExportTest.assertEquals((Object)("myStringPropertyValue_" + i), (Object)msg.getStringProperty("myStringProperty"));
            XmlImportExportTest.assertEquals((Object)true, (Object)msg.getPropertyNames().contains(SimpleString.toSimpleString((String)"myNullStringProperty")));
            XmlImportExportTest.assertEquals(null, (Object)msg.getStringProperty("myNullStringProperty"));
            XmlImportExportTest.assertEquals((Object)international.toString(), (Object)msg.getStringProperty("myNonAsciiStringProperty"));
            XmlImportExportTest.assertEquals((Object)special, (Object)msg.getStringProperty("mySpecialCharacters"));
            XmlImportExportTest.assertEquals((Object)new SimpleString("mySimpleStringPropertyValue_" + i), (Object)msg.getSimpleStringProperty(new SimpleString("mySimpleStringProperty")));
            XmlImportExportTest.assertEquals((Object)true, (Object)msg.getPropertyNames().contains(SimpleString.toSimpleString((String)"myNullSimpleStringProperty")));
            XmlImportExportTest.assertEquals(null, (Object)msg.getSimpleStringProperty("myNullSimpleStringProperty"));
        }
    }

    private ClientSession basicSetUp() throws Exception {
        this.server = this.createServer(true);
        this.server.getConfiguration().getConnectorConfigurations().put("in-vm1", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.server.getConfiguration().getConnectorConfigurations().put("in-vm2", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.jmsServer = new JMSServerManagerImpl(this.server);
        this.addActiveMQComponent((ActiveMQComponent)this.jmsServer);
        this.namingContext = new InVMContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.namingContext));
        this.jmsServer.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        this.checkForLongs();
        return this.addClientSession(this.factory.createSession(false, true, true));
    }

    @Test
    public void testMessageTypes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)0, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)5, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)2, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)6, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)3, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)4L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)0L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)5L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)2L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)6L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)3L, (long)msg.getType());
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)0L, (long)msg.getType());
    }

    @Test
    public void testTextMessage() throws Exception {
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < 2608; ++i) {
            data.append("X");
        }
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)3, true);
        msg.getBodyBuffer().writeString(data.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)3L, (long)msg.getType());
        XmlImportExportTest.assertEquals((Object)data.toString(), (Object)msg.getBodyBuffer().readString());
    }

    @Test
    public void testBytesMessage() throws Exception {
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < 2610; ++i) {
            data.append("X");
        }
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        msg.getBodyBuffer().writeBytes(data.toString().getBytes());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)4L, (long)msg.getType());
        byte[] result = new byte[msg.getBodySize()];
        msg.getBodyBuffer().readBytes(result);
        XmlImportExportTest.assertEquals((long)data.toString().getBytes().length, (long)result.length);
    }

    @Test
    public void testMessageAttributes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        msg.setExpiration(Long.MAX_VALUE);
        msg.setPriority((byte)0);
        msg.setTimestamp(0x7FFFFFFFFFFFFFFEL);
        msg.setUserID((Object)UUIDGenerator.getInstance().generateUUID());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertEquals((long)Long.MAX_VALUE, (long)msg.getExpiration());
        XmlImportExportTest.assertEquals((long)0L, (long)msg.getPriority());
        XmlImportExportTest.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)msg.getTimestamp());
        XmlImportExportTest.assertNotNull((Object)msg.getUserID());
    }

    @Test
    public void testBindingAttributes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration("queueName1").setAddress("addressName1"));
        session.createQueue(new QueueConfiguration("queueName2").setAddress("addressName1").setFilterString("bob"));
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientSession.QueueQuery queueQuery = session.queueQuery(new SimpleString("queueName1"));
        XmlImportExportTest.assertEquals((Object)"addressName1", (Object)queueQuery.getAddress().toString());
        XmlImportExportTest.assertNull((Object)queueQuery.getFilterString());
        queueQuery = session.queueQuery(new SimpleString("queueName2"));
        XmlImportExportTest.assertEquals((Object)"addressName1", (Object)queueQuery.getAddress().toString());
        XmlImportExportTest.assertEquals((Object)"bob", (Object)queueQuery.getFilterString().toString());
        XmlImportExportTest.assertEquals((Object)true, (Object)queueQuery.isDurable());
    }

    @Test
    public void testLargeMessage() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i = 0; i < 204800; ++i) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte((long)i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        session.createQueue(new QueueConfiguration("A"));
        ClientProducer prod = session.createProducer("A");
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        session = this.factory.createSession(false, false);
        session.start();
        ClientConsumer cons = session.createConsumer("A");
        ClientMessage msg = cons.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((long)204800L, (long)msg.getBodySize());
        for (int i = 0; i < 204800; ++i) {
            XmlImportExportTest.assertEquals((long)XmlImportExportTest.getSamplebyte((long)i), (long)msg.getBodyBuffer().readByte());
        }
        msg.acknowledge();
        session.commit();
    }

    @Test
    public void testLargeMessagesNoTmpFiles() throws Exception {
        String[] flist;
        int i;
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i2 = 0; i2 < 204800; ++i2) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte((long)i2)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        session.createQueue(new QueueConfiguration("A"));
        ClientProducer prod = session.createProducer("A");
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.sort = true;
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        session = this.factory.createSession(false, false);
        session.start();
        ClientConsumer cons = session.createConsumer("A");
        ClientMessage msg = cons.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((long)204800L, (long)msg.getBodySize());
        for (i = 0; i < 204800; ++i) {
            XmlImportExportTest.assertEquals((long)XmlImportExportTest.getSamplebyte((long)i), (long)msg.getBodyBuffer().readByte());
        }
        msg = cons.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((long)204800L, (long)msg.getBodySize());
        for (i = 0; i < 204800; ++i) {
            XmlImportExportTest.assertEquals((long)XmlImportExportTest.getSamplebyte((long)i), (long)msg.getBodyBuffer().readByte());
        }
        msg.acknowledge();
        session.commit();
        File workingDir = new File(System.getProperty("user.dir"));
        for (String fn : flist = workingDir.list()) {
            XmlImportExportTest.assertFalse((String)("leftover: " + fn), (boolean)fn.endsWith(".tmp"));
        }
    }

    @Test
    public void testLargeJmsTextMessage() throws Exception {
        this.basicSetUp();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)"vm://0", (String)"test");
        Connection c = cf.createConnection();
        Session s = c.createSession(false, 1);
        this.server.createQueue(new QueueConfiguration("A").setRoutingType(RoutingType.ANYCAST));
        MessageProducer p = s.createProducer((Destination)ActiveMQJMSClient.createQueue((String)"A"));
        p.setDeliveryMode(2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 204800; ++i) {
            stringBuilder.append(RandomUtil.randomChar());
        }
        TextMessage textMessage = s.createTextMessage(stringBuilder.toString());
        textMessage.setStringProperty("_AMQ_DUPL_ID", String.valueOf(UUID.randomUUID()));
        p.send((Message)textMessage);
        c.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        c = cf.createConnection();
        s = c.createSession();
        MessageConsumer mc = s.createConsumer((Destination)ActiveMQJMSClient.createQueue((String)"A"));
        c.start();
        Message msg = mc.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        c.close();
    }

    @Test
    public void testPartialQueue() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration("myQueue1").setAddress("myAddress"));
        session.createQueue(new QueueConfiguration("myQueue2").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        ClientConsumer consumer = session.createConsumer("myQueue1");
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        msg.acknowledge();
        consumer.close();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        consumer = session.createConsumer("myQueue1");
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNull((Object)msg);
        consumer.close();
        consumer = session.createConsumer("myQueue2");
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
    }

    @Test
    public void testPagedMessageWithMissingBinding() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        String MY_QUEUE2 = "myQueue2";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(new QueueConfiguration("myQueue").setAddress("myAddress"));
        session.createQueue(new QueueConfiguration("myQueue2").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.deleteQueue("myQueue2");
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            XmlImportExportTest.assertNotNull((Object)message);
        }
        session.close();
        locator.close();
        this.server.stop();
    }

    @Test
    public void testPaging() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, true, true);
        session.createQueue(new QueueConfiguration("myQueue").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            XmlImportExportTest.assertNotNull((Object)message);
        }
    }

    @Test
    public void testPagedLargeMessage() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(new QueueConfiguration("myQueue").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i = 0; i < 204800; ++i) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte((long)i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            XmlImportExportTest.assertNotNull((Object)message);
        }
        ClientMessage msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((long)204800L, (long)msg.getBodySize());
        for (int i = 0; i < 204800; ++i) {
            XmlImportExportTest.assertEquals((long)XmlImportExportTest.getSamplebyte((long)i), (long)msg.getBodyBuffer().readByte());
        }
        session.close();
        locator.close();
        this.server.stop();
    }

    @Test
    public void testTransactional() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, false, true);
        ClientSession managementSession = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
    }

    @Test
    public void testBody() throws Exception {
        String QUEUE_NAME = QUEUE_NAME;
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)3, true);
        msg.getBodyBuffer().writeString("bob123");
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false, true);
        ClientSession managementSession = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((Object)"bob123", (Object)msg.getBodyBuffer().readString());
        session.close();
        locator.close();
        this.server.stop();
    }

    @Test
    public void testBody2() throws Exception {
        String QUEUE_NAME = QUEUE_NAME;
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage(true);
        byte[] bodyTst = new byte[10];
        for (int i = 0; i < 10; ++i) {
            bodyTst[i] = (byte)(i + 1);
        }
        msg.getBodyBuffer().writeBytes(bodyTst);
        XmlImportExportTest.assertEquals((long)bodyTst.length, (long)msg.getBodySize());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false, true);
        ClientSession managementSession = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        XmlImportExportTest.assertNotNull((Object)msg);
        XmlImportExportTest.assertEquals((long)msg.getBodySize(), (long)bodyTst.length);
        byte[] bodyRead = new byte[bodyTst.length];
        msg.getBodyBuffer().readBytes(bodyRead);
        XmlImportExportTest.assertEqualsByteArrays((byte[])bodyTst, (byte[])bodyRead);
        session.close();
        locator.close();
        this.server.stop();
    }

    @Test
    public void testRoutingTypes() throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        ClientSession session = this.basicSetUp();
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        session.createAddress(myAddress, routingTypes, false);
        session.createQueue(new QueueConfiguration("myQueue1").setAddress(myAddress));
        session.createQueue(new QueueConfiguration("myQueue2").setAddress(myAddress));
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.locator.createSessionFactory();
        session = this.factory.createSession(false, false, true);
        ClientSession managementSession = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        XmlImportExportTest.assertTrue((boolean)this.server.getAddressInfo(myAddress).getRoutingTypes().contains(RoutingType.ANYCAST));
        XmlImportExportTest.assertTrue((boolean)this.server.getAddressInfo(myAddress).getRoutingTypes().contains(RoutingType.MULTICAST));
    }
}

