/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.tests.unit.UnitTestLogger;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlignedJournalImplTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(AlignedJournalImplTest.class);
    private static final LoaderCallback dummyLoader = new LoaderCallback(){

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }

        public void addRecord(RecordInfo info) {
        }

        public void deleteRecord(long id) {
        }

        public void updateRecord(RecordInfo info) {
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    };
    private SequentialFileFactory factory;
    JournalImpl journalImpl = null;
    private ArrayList<RecordInfo> records = null;
    private ArrayList<Long> incompleteTransactions = null;
    private ArrayList<PreparedTransactionInfo> transactions = null;

    @Test
    public void testBasicAlignment() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory(200, true);
        SequentialFile file = factory.createSequentialFile("test1");
        file.open();
        try {
            int i;
            ByteBuffer buffer = ByteBuffer.allocateDirect(200);
            for (i = 0; i < 200; ++i) {
                buffer.put(i, (byte)1);
            }
            file.writeDirect(buffer, true);
            buffer = ByteBuffer.allocate(400);
            for (i = 0; i < 400; ++i) {
                buffer.put(i, (byte)2);
            }
            file.writeDirect(buffer, true);
            buffer = ByteBuffer.allocate(600);
            file.position(0L);
            file.read(buffer);
            for (i = 0; i < 200; ++i) {
                Assert.assertEquals((long)1L, (long)buffer.get(i));
            }
            for (i = 201; i < 600; ++i) {
                Assert.assertEquals((String)("Position " + i), (long)2L, (long)buffer.get(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInconsistentAlignment() throws Exception {
        this.factory = new FakeSequentialFileFactory(512, true);
        try {
            this.journalImpl = new JournalImpl(2000, 2, 2, 0, 0, this.factory, "tt", "tt", 1000);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleAdd() throws Exception {
        int JOURNAL_SIZE = 1060;
        this.setupAndLoadJournal(1060, 10);
        this.journalImpl.appendAddRecord(13L, (byte)14, (EncodingSupport)new SimpleEncoding(1, 15), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(1060, 10);
        Assert.assertEquals((long)1L, (long)this.records.size());
        Assert.assertEquals((long)13L, (long)this.records.get((int)0).id);
        Assert.assertEquals((long)14L, (long)this.records.get((int)0).userRecordType);
        Assert.assertEquals((long)1L, (long)this.records.get((int)0).data.length);
        Assert.assertEquals((long)15L, (long)this.records.get((int)0).data[0]);
    }

    @Test
    public void testAppendAndUpdateRecords() throws Exception {
        int j;
        byte[] bytes;
        int i;
        int JOURNAL_SIZE = 1060;
        this.setupAndLoadJournal(1060, 10);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (i = 0; i < 25; ++i) {
            bytes = new byte[5];
            for (int j2 = 0; j2 < bytes.length; ++j2) {
                bytes[j2] = (byte)i;
            }
            this.journalImpl.appendAddRecord((long)i * 100L, (byte)i, bytes, false);
        }
        for (i = 25; i < 50; ++i) {
            SimpleEncoding support = new SimpleEncoding(5, (byte)i);
            this.journalImpl.appendAddRecord((long)i * 100L, (byte)i, (EncodingSupport)support, false);
        }
        this.setupAndLoadJournal(1060, 1024);
        Assert.assertEquals((long)50L, (long)this.records.size());
        i = 0;
        for (RecordInfo recordItem : this.records) {
            Assert.assertEquals((long)((long)i * 100L), (long)recordItem.id);
            Assert.assertEquals((long)i, (long)recordItem.getUserRecordType());
            Assert.assertEquals((long)5L, (long)recordItem.data.length);
            for (j = 0; j < 5; ++j) {
                Assert.assertEquals((long)((byte)i), (long)recordItem.data[j]);
            }
            ++i;
        }
        for (i = 40; i < 50; ++i) {
            bytes = new byte[10];
            for (int j3 = 0; j3 < 10; ++j3) {
                bytes[j3] = 120;
            }
            this.journalImpl.appendUpdateRecord((long)i * 100L, (byte)i, bytes, false);
        }
        this.setupAndLoadJournal(1060, 1024);
        i = 0;
        for (RecordInfo recordItem : this.records) {
            if (i < 50) {
                Assert.assertEquals((long)((long)i * 100L), (long)recordItem.id);
                Assert.assertEquals((long)i, (long)recordItem.getUserRecordType());
                Assert.assertEquals((long)5L, (long)recordItem.data.length);
                for (j = 0; j < 5; ++j) {
                    Assert.assertEquals((long)((byte)i), (long)recordItem.data[j]);
                }
            } else {
                Assert.assertEquals((long)((long)(i - 10) * 100L), (long)recordItem.id);
                Assert.assertEquals((long)(i - 10), (long)recordItem.getUserRecordType());
                Assert.assertTrue((boolean)recordItem.isUpdate);
                Assert.assertEquals((long)10L, (long)recordItem.data.length);
                for (j = 0; j < 10; ++j) {
                    Assert.assertEquals((long)120L, (long)recordItem.data[j]);
                }
            }
            ++i;
        }
        this.journalImpl.stop();
    }

    @Test
    public void testPartialDelete() throws Exception {
        int i;
        int JOURNAL_SIZE = 10000;
        this.setupAndLoadJournal(10000, 100);
        this.journalImpl.setAutoReclaim(false);
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.debugWait();
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        UnitTestLogger.LOGGER.debug("Initial:--> " + this.journalImpl.debug());
        UnitTestLogger.LOGGER.debug("_______________________________");
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        Assert.assertEquals((long)3L, (long)this.factory.listFiles("tt").size());
        for (i = 10; i < 50; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(10000, 100);
        Assert.assertEquals((long)10L, (long)this.records.size());
        Assert.assertEquals((long)3L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testAddAndDeleteReclaimWithoutTransactions() throws Exception {
        int i;
        int JOURNAL_SIZE = 10000;
        this.setupAndLoadJournal(10000, 1);
        this.journalImpl.setAutoReclaim(false);
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.debugWait();
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        UnitTestLogger.LOGGER.debug("Initial:--> " + this.journalImpl.debug());
        UnitTestLogger.LOGGER.debug("_______________________________");
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        }
        this.journalImpl.debugWait();
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(1000L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        this.journalImpl.debugWait();
        Assert.assertEquals((long)3L, (long)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(10000, 1);
        Assert.assertEquals((long)1L, (long)this.records.size());
        Assert.assertEquals((long)1000L, (long)this.records.get((int)0).id);
        this.journalImpl.checkReclaimStatus();
        UnitTestLogger.LOGGER.debug(this.journalImpl.debug());
        this.journalImpl.debugWait();
        UnitTestLogger.LOGGER.debug("Final:--> " + this.journalImpl.debug());
        UnitTestLogger.LOGGER.debug("_______________________________");
        UnitTestLogger.LOGGER.debug("Files bufferSize:" + this.factory.listFiles("tt").size());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testReloadWithTransaction() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        this.journalImpl.appendAddRecordTransactional(1L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        try {
            this.journalImpl.appendCommitRecord(1L, true);
            Assert.fail((String)"Supposed to throw exception");
        }
        catch (Exception e) {
            UnitTestLogger.LOGGER.warn(e);
        }
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
    }

    @Test
    public void testReloadWithInterruptedTransaction() throws Exception {
        int JOURNAL_SIZE = 1100;
        this.setupAndLoadJournal(1100, 100);
        this.journalImpl.setAutoReclaim(false);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(77L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.debugWait();
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.journalImpl.appendAddRecordTransactional(78L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(1100, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        Assert.assertEquals((long)2L, (long)this.incompleteTransactions.size());
        Assert.assertEquals((Object)77L, (Object)this.incompleteTransactions.get(0));
        Assert.assertEquals((Object)78L, (Object)this.incompleteTransactions.get(1));
        try {
            this.journalImpl.appendCommitRecord(77L, true);
            Assert.fail((String)"Supposed to throw exception");
        }
        catch (Exception e) {
            UnitTestLogger.LOGGER.debug("Expected exception " + e, e);
        }
        this.setupAndLoadJournal(1100, 100);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
    }

    @Test
    public void testReloadWithCompletedTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)10L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)10L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendAddRecord(100L, (byte)1, (EncodingSupport)new SimpleEncoding(5, 1), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(101L, (byte)1, (EncodingSupport)new SimpleEncoding(5, 1), false);
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)1L, (long)this.journalImpl.getDataFilesCount());
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)1L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)3L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testTotalSize() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        this.journalImpl.appendAddRecordTransactional(1L, 2L, (byte)3, (EncodingSupport)new SimpleEncoding(1869, 4));
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)1L, (long)this.records.size());
    }

    @Test
    public void testReloadInvalidCheckSizeOnTransaction() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i = 0; i < 2; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        log.debug((Object)("Files = " + this.factory.listFiles("tt")));
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(28);
        int posCheckSize = buffer.position();
        Assert.assertEquals((long)32L, (long)buffer.getInt());
        buffer.position(posCheckSize);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testPartiallyBrokenFile() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i = 0; i < 20; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
            this.journalImpl.appendAddRecordTransactional(2L, (long)i + 20L, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.debugWait();
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(28);
        int posCheckSize = buffer.position();
        Assert.assertEquals((long)32L, (long)buffer.getInt());
        buffer.position(posCheckSize);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)20L, (long)this.records.size());
        this.journalImpl.checkReclaimStatus();
    }

    @Test
    public void testReduceFreeFiles() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100, 10);
        Assert.assertEquals((long)10L, (long)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(2000, 100, 2);
        Assert.assertEquals((long)10L, (long)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0), false);
            this.journalImpl.forceMoveNextFile();
        }
        this.setupAndLoadJournal(2000, 100, 2);
        Assert.assertEquals((long)10L, (long)this.records.size());
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(2000, 100, 2);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testReloadIncompleteTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 1);
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        for (i = 10; i < 20; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(1);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        buffer.rewind();
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(2000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testPrepareAloneOnSeparatedFile() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.forceMoveNextFile();
        SimpleEncoding xidEncoding = new SimpleEncoding(10, 97);
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xidEncoding, false);
        this.journalImpl.appendCommitRecord(1L, false);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendAddRecord(100L, (byte)0, (EncodingSupport)new SimpleEncoding(1, 10), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)1L, (long)this.records.size());
    }

    @Test
    public void testCommitWithMultipleFiles() throws Exception {
        int i;
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (i = 0; i < 50; ++i) {
            if (i == 10) {
                this.journalImpl.forceMoveNextFile();
            }
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        for (i = 0; i < 10; ++i) {
            if (i == 5) {
                this.journalImpl.forceMoveNextFile();
            }
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(20000, 100);
        Assert.assertEquals((long)40L, (long)this.records.size());
    }

    @Test
    public void testSimplePrepare() throws Exception {
        int JOURNAL_SIZE = 3072;
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        SimpleEncoding xid = new SimpleEncoding(10, 1);
        this.journalImpl.appendAddRecord(10L, (byte)0, (EncodingSupport)new SimpleEncoding(10, 0), false);
        this.journalImpl.appendDeleteRecordTransactional(1L, 10L, (EncodingSupport)new SimpleEncoding(100, 106));
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xid, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        Assert.assertEquals((long)1L, (long)this.transactions.get(0).getRecordsToDelete().size());
        Assert.assertEquals((long)1L, (long)this.records.size());
        for (RecordInfo record : this.transactions.get(0).getRecordsToDelete()) {
            byte[] data = record.data;
            Assert.assertEquals((long)100L, (long)data.length);
            for (byte element : data) {
                Assert.assertEquals((long)106L, (long)element);
            }
        }
        Assert.assertEquals((long)10L, (long)this.transactions.get(0).getExtraData().length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)1L, (long)this.transactions.get(0).getExtraData()[i]);
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        Assert.assertEquals((long)0L, (long)this.records.size());
    }

    @Test
    public void testReloadWithPreparedTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 3072;
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i2 = 0; i2 < 10; ++i2) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i2, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.debugWait();
        SimpleEncoding xid1 = new SimpleEncoding(10, 1);
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xid1, false);
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(3072, 1024);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        Assert.assertEquals((long)10L, (long)this.transactions.get(0).getExtraData().length);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)1L, (long)this.transactions.get(0).getExtraData()[i]);
        }
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)10L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(3072, 1024);
        Assert.assertEquals((long)10L, (long)this.records.size());
        this.journalImpl.checkReclaimStatus();
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        SimpleEncoding xid2 = new SimpleEncoding(15, 2);
        this.journalImpl.appendPrepareRecord(2L, (EncodingSupport)xid2, false);
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        Assert.assertEquals((long)15L, (long)this.transactions.get(0).getExtraData().length);
        for (byte element : this.transactions.get(0).getExtraData()) {
            Assert.assertEquals((long)2L, (long)element);
        }
        Assert.assertEquals((long)10L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)12L, (long)this.factory.listFiles("tt").size());
        this.journalImpl.appendCommitRecord(2L, false);
        this.setupAndLoadJournal(3072, 1);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.flush();
    }

    @Test
    public void testReloadInvalidPrepared() throws Exception {
        int JOURNAL_SIZE = 3000;
        this.setupAndLoadJournal(3000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
        }
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)new SimpleEncoding(13, 0), false);
        this.setupAndLoadJournal(3000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(1);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(3000, 100);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
    }

    @Test
    public void testReclaimAfterRollabck() throws Exception {
        int JOURNAL_SIZE = 2000;
        int COUNT = 10;
        this.setupAndLoadJournal(2000, 1);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendRollbackRecord(1L, false);
        this.journalImpl.forceMoveNextFile();
        AlignedJournalImplTest.assertTrue((boolean)Wait.waitFor(() -> this.factory.listFiles("tt").size() == 13, (long)2000L, (long)50L));
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
        this.setupAndLoadJournal(2000, 1);
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testDecreaseAlignment() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 512);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(2048, 100);
        Assert.assertEquals((long)10L, (long)this.records.size());
        this.setupAndLoadJournal(2048, 1);
        Assert.assertEquals((long)10L, (long)this.records.size());
    }

    @Test
    public void testIncreaseAlignment() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 1);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(2048, 100);
        Assert.assertEquals((long)10L, (long)this.records.size());
        this.setupAndLoadJournal(2048, 512);
        Assert.assertEquals((long)10L, (long)this.records.size());
    }

    @Test
    public void testEmptyPrepare() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 1);
        this.journalImpl.appendPrepareRecord(2L, (EncodingSupport)new SimpleEncoding(10, 106), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(1L, (byte)0, (EncodingSupport)new SimpleEncoding(10, 107), false);
        this.setupAndLoadJournal(2048, 1);
        Assert.assertEquals((long)1L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        this.journalImpl.forceMoveNextFile();
        this.setupAndLoadJournal(2048, 1);
        Assert.assertEquals((long)1L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)1L, (long)this.transactions.size());
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendDeleteRecord(1L, false);
        this.journalImpl.forceMoveNextFile();
        this.setupAndLoadJournal(2048, 0);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
    }

    @Test
    public void testReclaimingAfterConcurrentAddsAndDeletesTx() throws Exception {
        this.testReclaimingAfterConcurrentAddsAndDeletes(true);
    }

    @Test
    public void testReclaimingAfterConcurrentAddsAndDeletesNonTx() throws Exception {
        this.testReclaimingAfterConcurrentAddsAndDeletes(false);
    }

    public void testReclaimingAfterConcurrentAddsAndDeletes(final boolean transactional) throws Exception {
        int JOURNAL_SIZE = 10240;
        this.setupAndLoadJournal(10240, 1);
        Assert.assertEquals((long)0L, (long)this.records.size());
        Assert.assertEquals((long)0L, (long)this.transactions.size());
        final CountDownLatch latchReady = new CountDownLatch(2);
        final CountDownLatch latchStart = new CountDownLatch(1);
        final AtomicInteger finishedOK = new AtomicInteger(0);
        final LinkedBlockingQueue queueDelete = new LinkedBlockingQueue();
        int NUMBER_OF_ELEMENTS = 500;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    latchReady.countDown();
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchStart);
                    for (int i = 0; i < 500; ++i) {
                        if (transactional) {
                            AlignedJournalImplTest.this.journalImpl.appendAddRecordTransactional((long)i, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
                            AlignedJournalImplTest.this.journalImpl.appendCommitRecord((long)i, false);
                        } else {
                            AlignedJournalImplTest.this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1), false);
                        }
                        queueDelete.offer(i);
                    }
                    finishedOK.incrementAndGet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    Integer toDelete;
                    latchReady.countDown();
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchStart);
                    for (int i = 0; i < 500 && (toDelete = (Integer)queueDelete.poll(10L, TimeUnit.SECONDS)) != null; ++i) {
                        if (transactional) {
                            AlignedJournalImplTest.this.journalImpl.appendDeleteRecordTransactional((long)toDelete.intValue(), (long)toDelete.intValue(), (EncodingSupport)new SimpleEncoding(50, 1));
                            AlignedJournalImplTest.this.journalImpl.appendCommitRecord((long)i, false);
                            continue;
                        }
                        AlignedJournalImplTest.this.journalImpl.appendDeleteRecord((long)toDelete.intValue(), false);
                    }
                    finishedOK.incrementAndGet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t1.start();
        t2.start();
        ActiveMQTestBase.waitForLatch((CountDownLatch)latchReady);
        latchStart.countDown();
        t1.join();
        t2.join();
        Assert.assertEquals((long)2L, (long)finishedOK.intValue());
        this.journalImpl.debugWait();
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        this.journalImpl.checkReclaimStatus();
        Assert.assertEquals((long)0L, (long)this.journalImpl.getDataFilesCount());
        Assert.assertEquals((long)2L, (long)this.factory.listFiles("tt").size());
    }

    @Test
    public void testAlignmentOverReload() throws Exception {
        this.factory = new FakeSequentialFileFactory(512, false);
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.journalImpl.start();
        this.journalImpl.load(dummyLoader);
        this.journalImpl.appendAddRecord(1L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 97), false);
        this.journalImpl.appendAddRecord(2L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.appendAddRecord(3L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.appendAddRecord(4L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.stop();
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        this.journalImpl.load(dummyLoader);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendDeleteRecord(1L, false);
        this.journalImpl.appendDeleteRecord(2L, false);
        this.journalImpl.appendDeleteRecord(3L, false);
        this.journalImpl.appendDeleteRecord(4L, false);
        this.journalImpl.stop();
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        ArrayList info = new ArrayList();
        ArrayList trans = new ArrayList();
        this.journalImpl.load(info, trans, null);
        Assert.assertEquals((long)0L, (long)info.size());
        Assert.assertEquals((long)0L, (long)trans.size());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.records = new ArrayList();
        this.transactions = new ArrayList();
        this.incompleteTransactions = new ArrayList();
        this.factory = null;
        this.journalImpl = null;
    }

    @After
    public void tearDown() throws Exception {
        AlignedJournalImplTest.stopComponent((ActiveMQComponent)this.journalImpl);
        if (this.factory != null) {
            this.factory.stop();
        }
        this.records = null;
        this.transactions = null;
        this.incompleteTransactions = null;
        this.factory = null;
        this.journalImpl = null;
        super.tearDown();
    }

    private void setupAndLoadJournal(int journalSize, int alignment) throws Exception {
        this.setupAndLoadJournal(journalSize, alignment, 2);
    }

    private void setupAndLoadJournal(int journalSize, int alignment, int numberOfMinimalFiles) throws Exception {
        if (this.factory == null) {
            this.factory = new FakeSequentialFileFactory(alignment, true);
        }
        if (this.journalImpl != null) {
            this.journalImpl.stop();
        }
        this.journalImpl = new JournalImpl(journalSize, numberOfMinimalFiles, numberOfMinimalFiles, 0, 0, this.factory, "tt", "tt", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        this.records.clear();
        this.transactions.clear();
        this.incompleteTransactions.clear();
        this.journalImpl.load(this.records, this.transactions, new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
                log.debug((Object)("records.length = " + records.size()));
                AlignedJournalImplTest.this.incompleteTransactions.add(transactionID);
            }
        });
    }
}

