/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.remoting.responses.PrepareResponse;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(VersionedEntryWrappingInterceptor.class);
    @Inject
    protected VersionGenerator versionGenerator;
    private final InvocationSuccessFunction<VersionedPrepareCommand> prepareHandler = this::prepareHandler;
    private final InvocationSuccessFunction<VersionedPrepareCommand> afterPrepareHandler = this::afterPrepareHandler;
    private final InvocationFinallyFunction<VersionedCommitCommand> commitHandler = this::commitHandler;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        VersionedPrepareCommand versionedPrepareCommand = (VersionedPrepareCommand)command;
        if (ctx.isOriginLocal()) {
            versionedPrepareCommand.setVersionsSeen(((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead());
        }
        return this.wrapEntriesForPrepareAndApply(ctx, versionedPrepareCommand, this.prepareHandler);
    }

    private Object prepareHandler(InvocationContext nonTxCtx, VersionedPrepareCommand command, Object nil) {
        CompletionStage<Object> originVersionData;
        TxInvocationContext ctx = (TxInvocationContext)nonTxCtx;
        if (((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer()) {
            this.storeEntryVersionForStateTransfer(ctx);
            originVersionData = CompletableFutures.completedNull();
        } else {
            originVersionData = ctx.isOriginLocal() ? this.checkWriteSkew(ctx, command) : CompletableFutures.completedNull();
        }
        InvocationStage originVersionStage = VersionedEntryWrappingInterceptor.makeStage(this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, originVersionData));
        InvocationStage newVersionStage = originVersionStage.thenApplyMakeStage(ctx, command, (rCtx, rCommand, rv) -> {
            CompletionStage<Map<Object, IncrementableEntryVersion>> stage = rCtx.isOriginLocal() ? originVersionData : this.checkWriteSkew((TxInvocationContext)rCtx, (VersionedPrepareCommand)rCommand);
            return VersionedEntryWrappingInterceptor.asyncValue(stage.thenApply(vMap -> WriteSkewHelper.mergeInPrepareResponse(vMap, PrepareResponse.asPrepareResponse(rv))));
        });
        return newVersionStage.thenApply(ctx, command, this.afterPrepareHandler);
    }

    private Object afterPrepareHandler(InvocationContext ctx, VersionedPrepareCommand command, Object rv) {
        if (command.isOnePhaseCommit()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            ((AbstractCacheTransaction)txCtx.getCacheTransaction()).setUpdatedEntryVersions(command.getVersionsSeen());
            CompletionStage<Void> stage = this.commitContextEntries(ctx, null);
            return VersionedEntryWrappingInterceptor.delayedValue(stage, rv);
        }
        return rv;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        VersionedCommitCommand versionedCommitCommand = (VersionedCommitCommand)command;
        if (ctx.isOriginLocal()) {
            versionedCommitCommand.setUpdatedVersions(((AbstractCacheTransaction)ctx.getCacheTransaction()).getUpdatedEntryVersions());
        }
        return this.invokeNextAndHandle(ctx, versionedCommitCommand, this.commitHandler);
    }

    @Override
    protected CompletionStage<Void> commitContextEntry(CacheEntry<?, ?> entry, InvocationContext ctx, FlagAffectedCommand command, Flag stateTransferFlag, boolean l1Invalidation) {
        if (ctx.isInTxScope() && stateTransferFlag == null) {
            this.storeEntryVersion(entry, (TxInvocationContext)ctx);
        }
        return this.cdl.commitEntry(entry, command, ctx, stateTransferFlag, l1Invalidation);
    }

    private void storeEntryVersion(CacheEntry<?, ?> entry, TxInvocationContext<?> ctx) {
        IncrementableEntryVersion entryVersion = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getUpdatedEntryVersions().get(entry.getKey());
        if (entryVersion == null) {
            return;
        }
        PrivateMetadata.Builder builder = PrivateMetadata.getBuilder(entry.getInternalMetadata());
        builder.entryVersion(entryVersion);
        entry.setInternalMetadata(builder.build());
    }

    private void storeEntryVersionForStateTransfer(TxInvocationContext<?> ctx) {
        for (WriteCommand cmd : ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications()) {
            for (Object key : cmd.getAffectedKeys()) {
                PrivateMetadata metadata = cmd.getInternalMetadata(key);
                assert (metadata != null);
                IncrementableEntryVersion entryVersion = metadata.entryVersion();
                assert (entryVersion != null);
                CacheEntry entry = ctx.lookupEntry(key);
                PrivateMetadata.Builder builder = PrivateMetadata.getBuilder(entry.getInternalMetadata());
                entry.setInternalMetadata(builder.entryVersion(entryVersion).build());
                if (!log.isTraceEnabled()) continue;
                log.tracef("Updated entry from state transfer: %s", entry);
            }
        }
    }

    private Object commitHandler(InvocationContext ctx, VersionedCommitCommand command, Object rv, Throwable t) {
        return VersionedEntryWrappingInterceptor.delayedValue(this.doCommit(ctx, command), rv, t);
    }

    private CompletionStage<Map<Object, IncrementableEntryVersion>> checkWriteSkew(TxInvocationContext<?> ctx, VersionedPrepareCommand command) {
        return this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, command);
    }

    private CompletionStage<Void> doCommit(InvocationContext ctx, VersionedCommitCommand command) {
        if (!ctx.isOriginLocal()) {
            ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).setUpdatedEntryVersions(command.getUpdatedVersions());
        }
        return this.commitContextEntries(ctx, null);
    }
}

