/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.function.Consumer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.http.oidc.OidcMechanismFactory;
import org.wildfly.security.http.oidc.OidcSecurityRealm;

class VirtualHttpServerMechanismFactoryProcessor
implements DeploymentUnitProcessor {
    private static final String VIRTUAL_REALM = "virtual";

    VirtualHttpServerMechanismFactoryProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null || !VirtualHttpServerMechanismFactoryMarkerUtility.isVirtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit)) {
            return;
        }
        ServiceName virtualMechanismFactoryName = VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryName((DeploymentUnit)deploymentUnit);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder serviceBuilder = serviceTarget.addService(virtualMechanismFactoryName);
        OidcMechanismFactory virtualMechanismFactory = new OidcMechanismFactory();
        Consumer mechanismFactoryConsumer = serviceBuilder.provides(new ServiceName[]{virtualMechanismFactoryName});
        serviceBuilder.setInstance(Service.newInstance((Consumer)mechanismFactoryConsumer, (Object)virtualMechanismFactory));
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
        ServiceName virtualDomainName = VirtualDomainMarkerUtility.virtualDomainName((DeploymentUnit)deploymentUnit);
        serviceBuilder = serviceTarget.addService(virtualDomainName);
        SecurityDomain virtualDomain = SecurityDomain.builder().addRealm(VIRTUAL_REALM, (SecurityRealm)new OidcSecurityRealm()).build().setDefaultRealmName(VIRTUAL_REALM).setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        Consumer securityDomainConsumer = serviceBuilder.provides(new ServiceName[]{virtualDomainName});
        serviceBuilder.setInstance(Service.newInstance((Consumer)securityDomainConsumer, (Object)virtualDomain));
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

