/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.Assert;
import org.junit.Test;

public class CoreClientTest
extends ActiveMQTestBase {
    @Test
    public void testCoreClientNetty() throws Exception {
        this.testCoreClient(true, null);
    }

    @Test
    public void testCoreClientInVM() throws Exception {
        this.testCoreClient(false, null);
    }

    @Test
    public void testCoreClientWithInjectedThreadPools() throws Exception {
        ExecutorService threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ScheduledThreadPoolExecutor scheduledThreadPool = new ScheduledThreadPoolExecutor(10);
        ServerLocator locator = this.createNonHALocator(false);
        boolean setThreadPools = locator.setThreadPools((Executor)threadPool, (ScheduledExecutorService)scheduledThreadPool);
        CoreClientTest.assertTrue((boolean)setThreadPools);
        this.testCoreClient(true, locator);
        threadPool.shutdown();
        scheduledThreadPool.shutdown();
        threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        scheduledThreadPool.awaitTermination(60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoreClientWithGlobalThreadPoolParamtersChanged() throws Exception {
        int originalScheduled = ActiveMQClient.getGlobalScheduledThreadPoolSize();
        int originalGlobal = ActiveMQClient.getGlobalThreadPoolSize();
        try {
            ActiveMQClient.setGlobalThreadPoolProperties((int)2, (int)1);
            ActiveMQClient.clearThreadPools();
            ServerLocator locator = this.createNonHALocator(false);
            this.testCoreClient(true, locator);
        }
        finally {
            ActiveMQClient.setGlobalThreadPoolProperties((int)originalGlobal, (int)originalScheduled);
            ActiveMQClient.clearThreadPools();
        }
    }

    private void testCoreClient(boolean netty, ServerLocator serverLocator) throws Exception {
        SimpleString QUEUE = new SimpleString("CoreClientTestQueue");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultConfig(netty), (boolean)false));
        server.start();
        ServerLocator locator = serverLocator == null ? this.createNonHALocator(netty) : serverLocator;
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putStringProperty("foo", "bar");
            message.setAddress(QUEUE);
            message.getBodyBuffer().writeString("testINVMCoreClient");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            ActiveMQBuffer buffer = message2.getBodyBuffer();
            Assert.assertEquals((Object)"testINVMCoreClient", (Object)buffer.readString());
            message2.acknowledge();
        }
        sf.close();
    }

    @Test
    public void testCoreClientPrefixes() throws Exception {
        this.internalTestCoreClientPrefixes(false);
    }

    @Test
    public void testCoreClientPrefixesWithSecurity() throws Exception {
        this.internalTestCoreClientPrefixes(true);
    }

    public void internalTestCoreClientPrefixes(boolean security) throws Exception {
        String address;
        String queueName;
        ConfigurationImpl configuration = this.createBasicConfig();
        configuration.clearAcceptorConfigurations();
        configuration.addAddressesSetting("#", new AddressSettings().setMaxSizeBytes(0xA00000L).setPageSizeBytes(0x100000));
        String baseAddress = "foo";
        ArrayList<String> anycastPrefixes = new ArrayList<String>();
        anycastPrefixes.add("anycast://");
        anycastPrefixes.add("queue://");
        anycastPrefixes.add("jms.queue.");
        ArrayList<String> multicastPrefixes = new ArrayList<String>();
        multicastPrefixes.add("multicast://");
        multicastPrefixes.add("topic://");
        multicastPrefixes.add("jms.topic.");
        String locatorString = "tcp://localhost:5445";
        StringBuilder acceptor = new StringBuilder(locatorString + "?PROTOCOLS=CORE;anycastPrefix=");
        for (String prefix : anycastPrefixes) {
            acceptor.append(prefix + ",");
        }
        acceptor.append(";multicastPrefix=");
        for (String prefix : multicastPrefixes) {
            acceptor.append(prefix + ",");
        }
        configuration.addAcceptorConfiguration("prefix", acceptor.toString());
        ActiveMQJAASSecurityManager securityManager = null;
        if (security) {
            configuration.setSecurityEnabled(true);
            SecurityConfiguration securityConfiguration = new SecurityConfiguration();
            securityConfiguration.addUser("myUser", "myPass");
            securityConfiguration.addRole("myUser", "myrole");
            securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), securityConfiguration);
        }
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)configuration, securityManager));
        server.start();
        Role myRole = new Role("myrole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> anySet = new HashSet<Role>();
        anySet.add(myRole);
        server.getSecurityRepository().addMatch(baseAddress, anySet);
        ServerLocator locator = this.addServerLocator(ServerLocatorImpl.newLocator((String)locatorString));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession("myUser", "myPass", false, true, true, false, 0);
        HashMap<String, ClientConsumer> consumerMap = new HashMap<String, ClientConsumer>();
        for (String prefix : anycastPrefixes) {
            queueName = UUIDGenerator.getInstance().generateSimpleStringUUID().toString();
            address = prefix + baseAddress;
            session.createQueue(new QueueConfiguration(queueName).setAddress(prefix + baseAddress).setDurable(Boolean.valueOf(false)));
            consumerMap.put(address, session.createConsumer(queueName));
        }
        for (String prefix : multicastPrefixes) {
            queueName = UUIDGenerator.getInstance().generateSimpleStringUUID().toString();
            address = prefix + baseAddress;
            session.createQueue(new QueueConfiguration(queueName).setAddress(prefix + baseAddress).setDurable(Boolean.valueOf(false)));
            consumerMap.put(address, session.createConsumer(queueName));
        }
        session.start();
        int numMessages = 3;
        for (String prefix : anycastPrefixes) {
            ClientConsumer consumer;
            ClientProducer producer = session.createProducer(prefix + baseAddress);
            for (int i = 0; i < 3; ++i) {
                ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
                message.getBodyBuffer().writeString("testINVMCoreClient");
                producer.send((Message)message);
            }
            for (String queuePrefix : anycastPrefixes) {
                consumer = (ClientConsumer)consumerMap.get(queuePrefix + baseAddress);
                for (int i = 0; i < 3 / anycastPrefixes.size(); ++i) {
                    ClientMessage message = consumer.receive(1000L);
                    CoreClientTest.assertNotNull((Object)message);
                    message.acknowledge();
                }
                CoreClientTest.assertNull((Object)consumer.receiveImmediate());
            }
            for (String multicastPrefix : multicastPrefixes) {
                consumer = (ClientConsumer)consumerMap.get(multicastPrefix + baseAddress);
                CoreClientTest.assertNull((Object)consumer.receiveImmediate());
            }
        }
        sf.close();
    }
}

