/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.Before;
import org.junit.Test;

public class FullQualifiedQueueTest
extends ActiveMQTestBase {
    private SimpleString anycastAddress = new SimpleString("address.anycast");
    private SimpleString multicastAddress = new SimpleString("address.multicast");
    private SimpleString mixedAddress = new SimpleString("address.mixed");
    private SimpleString anycastQ1 = new SimpleString("q1");
    private SimpleString anycastQ2 = new SimpleString("q2");
    private SimpleString anycastQ3 = new SimpleString("q3");
    private SimpleString multicastQ1 = new SimpleString("q4");
    private SimpleString multicastQ2 = new SimpleString("q5");
    private SimpleString multicastQ3 = new SimpleString("q6");
    private ActiveMQServer server;
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, true);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
    }

    @Test
    public void testMixedQueues() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.multicastQ1).setAddress(this.mixedAddress));
        this.server.createQueue(new QueueConfiguration(this.multicastQ2).setAddress(this.mixedAddress));
        this.server.createQueue(new QueueConfiguration(this.multicastQ3).setAddress(this.mixedAddress));
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.anycastQ2).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.anycastQ3).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.mixedAddress);
        int num = 3;
        this.sendMessages(session, producer, 3);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ3));
        ClientConsumer consumer4 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ1));
        ClientConsumer consumer5 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ2));
        ClientConsumer consumer6 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ3));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        this.instanceLog.debug((Object)("consumer1 : " + m));
        m.acknowledge();
        m = consumer2.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        this.instanceLog.debug((Object)("consumer2 : " + m));
        m.acknowledge();
        m = consumer3.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        this.instanceLog.debug((Object)("consumer3 : " + m));
        m.acknowledge();
        for (int i = 0; i < 3; ++i) {
            m = consumer4.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            this.instanceLog.debug((Object)("consumer4 : " + m));
            m.acknowledge();
            m = consumer5.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            this.instanceLog.debug((Object)("consumer5 : " + m));
            m.acknowledge();
            m = consumer6.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            this.instanceLog.debug((Object)("consumer6 : " + m));
            m.acknowledge();
        }
        session.commit();
        for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3, this.multicastQ1, this.multicastQ2, this.multicastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)q));
            FullQualifiedQueueTest.assertTrue((boolean)query.isExists());
            FullQualifiedQueueTest.assertEquals((Object)this.mixedAddress, (Object)query.getAddress());
            FullQualifiedQueueTest.assertEquals((Object)q, (Object)query.getName());
            FullQualifiedQueueTest.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testMulticastQueues() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.multicastQ1).setAddress(this.multicastAddress));
        this.server.createQueue(new QueueConfiguration(this.multicastQ2).setAddress(this.multicastAddress));
        this.server.createQueue(new QueueConfiguration(this.multicastQ3).setAddress(this.multicastAddress));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.multicastAddress);
        this.sendMessages(session, producer, 1);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ3));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        m.acknowledge();
        m = consumer2.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        m.acknowledge();
        m = consumer3.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        m.acknowledge();
        session.commit();
        for (SimpleString q : new SimpleString[]{this.multicastQ1, this.multicastQ2, this.multicastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)q));
            FullQualifiedQueueTest.assertTrue((boolean)query.isExists());
            FullQualifiedQueueTest.assertEquals((Object)this.multicastAddress, (Object)query.getAddress());
            FullQualifiedQueueTest.assertEquals((Object)q, (Object)query.getName());
            FullQualifiedQueueTest.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testAnycastQueues() throws Exception {
        int i;
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.anycastQ2).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.anycastQ3).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer1 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1).toString());
        for (int i2 = 0; i2 < 2; ++i2) {
            producer1.send((Message)session.createMessage(false));
        }
        FullQualifiedQueueTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ1).getMessageCount() == 2L, (long)2000L, (long)200L));
        ClientProducer producer2 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2).toString());
        for (int i3 = 0; i3 < 3; ++i3) {
            producer2.send((Message)session.createMessage(false));
        }
        FullQualifiedQueueTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ2).getMessageCount() == 3L, (long)2000L, (long)200L));
        ClientProducer producer3 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3).toString());
        for (int i4 = 0; i4 < 5; ++i4) {
            producer3.send((Message)session.createMessage(false));
        }
        FullQualifiedQueueTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ3).getMessageCount() == 5L, (long)2000L, (long)200L));
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3));
        ClientMessage m = null;
        for (i = 0; i < 2; ++i) {
            m = consumer1.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            m.acknowledge();
        }
        for (i = 0; i < 3; ++i) {
            m = consumer2.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            m.acknowledge();
        }
        for (i = 0; i < 5; ++i) {
            m = consumer3.receive(2000L);
            FullQualifiedQueueTest.assertNotNull((Object)m);
            m.acknowledge();
        }
        session.commit();
        for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)q));
            FullQualifiedQueueTest.assertTrue((boolean)query.isExists());
            FullQualifiedQueueTest.assertEquals((Object)this.anycastAddress, (Object)query.getAddress());
            FullQualifiedQueueTest.assertEquals((Object)q, (Object)query.getName());
            FullQualifiedQueueTest.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testSpecialCase() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.anycastAddress);
        this.sendMessages(session, producer, 1);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)new SimpleString(""), (SimpleString)this.anycastQ1));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        FullQualifiedQueueTest.assertNotNull((Object)m);
        m.acknowledge();
        session.commit();
        consumer1.close();
        try {
            session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastQ1, (SimpleString)new SimpleString("")));
            FullQualifiedQueueTest.fail((String)"should get exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
            // empty catch block
        }
        try {
            session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)new SimpleString(""), (SimpleString)new SimpleString("")));
            FullQualifiedQueueTest.fail((String)"should get exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
            // empty catch block
        }
    }
}

