/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ClusterWithBackupFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Test;

public class LiveVoteOnBackupFailureClusterTest
extends ClusterWithBackupFailoverTestBase {
    @Override
    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, new int[]{1, 2});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, new int[]{0, 2});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, new int[]{0, 1});
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, new int[]{1, 2});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, new int[]{0, 2});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 5, new int[]{0, 1});
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupBackupServer(3, 0, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupBackupServer(4, 1, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupBackupServer(5, 2, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupLiveServer(0, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupLiveServer(1, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupLiveServer(2, this.isFileStorage(), this.haType(), this.isNetty(), false);
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicaPolicyConfiguration)this.servers[4].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicaPolicyConfiguration)this.servers[5].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
    }

    @Override
    protected ClusterTestBase.HAType haType() {
        return ClusterTestBase.HAType.SharedNothingReplication;
    }

    @Test
    public void testLiveVoteSucceedsAfterBackupFailure() throws Exception {
        int i;
        this.startCluster();
        for (i = 0; i < this.servers.length; ++i) {
            this.waitForServerToStart(this.servers[i]);
        }
        for (i = 3; i < this.servers.length; ++i) {
            Wait.waitFor(() -> this.servers[3].isReplicaSync());
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.servers[0].getReplicationManager().getBackupTransportConnection().addFailureListener(new FailureListener(){

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                latch.countDown();
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                latch.countDown();
            }
        });
        this.servers[3].stop();
        latch.await(30L, TimeUnit.SECONDS);
        Thread.sleep(10000L);
        LiveVoteOnBackupFailureClusterTest.assertTrue((boolean)this.servers[0].isStarted());
    }

    private void startCluster() throws Exception {
        int[] liveServerIDs = new int[]{0, 1, 2};
        this.setupCluster();
        this.startServers(0, 1, 2);
        new BackupSyncDelay(this.servers[4], this.servers[1], 121);
        this.startServers(3, 4, 5);
        for (int i : liveServerIDs) {
            LiveVoteOnBackupFailureClusterTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
    }
}

