/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class WildcardAddressManagerUnitTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(WildcardAddressManagerUnitTest.class);

    @Test
    public void testUnitOnWildCardFailingScenario() throws Exception {
        int errors = 0;
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addBinding((Binding)new BindingFake("Topic1", "Topic1"));
        ad.addBinding((Binding)new BindingFake("Topic1", "one"));
        ad.addBinding((Binding)new BindingFake("*", "two"));
        ad.removeBinding(SimpleString.toSimpleString((String)"one"), null);
        try {
            ad.removeBinding(SimpleString.toSimpleString((String)"two"), null);
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        try {
            ad.addBinding((Binding)new BindingFake("Topic1", "three"));
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        WildcardAddressManagerUnitTest.assertEquals((String)"Exception happened during the process", (long)0L, (long)errors);
    }

    @Test
    public void testUnitOnWildCardFailingScenarioFQQN() throws Exception {
        int errors = 0;
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addBinding((Binding)new BindingFake("Topic1", "Topic1"));
        ad.addBinding((Binding)new BindingFake("Topic1", "one"));
        ad.addBinding((Binding)new BindingFake("*", "two"));
        ad.removeBinding(SimpleString.toSimpleString((String)"Topic1::one"), null);
        try {
            ad.removeBinding(SimpleString.toSimpleString((String)"*::two"), null);
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        try {
            ad.addBinding((Binding)new BindingFake("Topic1", "three"));
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        WildcardAddressManagerUnitTest.assertEquals((String)"Exception happened during the process", (long)0L, (long)errors);
    }

    @Test
    public void testWildCardAddressRemoval() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Queue1.#"), RoutingType.ANYCAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.#"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.#", "two"));
        ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.topic")).getBindings().size());
        ad.removeAddressInfo(SimpleString.toSimpleString((String)"Topic1.#"));
        WildcardAddressManagerUnitTest.assertNull((Object)ad.getAddressInfo(SimpleString.toSimpleString((String)"Topic1.#")));
    }

    @Test
    public void testWildCardAddRemoveBinding() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        SimpleString address = SimpleString.toSimpleString((String)"Queue1.1");
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Queue1.#"), RoutingType.ANYCAST));
        BindingFake bindingFake = new BindingFake("Queue1.#", "one");
        Assert.assertTrue((boolean)ad.addBinding((Binding)bindingFake));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindingsForRoutingAddress(address).getBindings().size());
        ad.removeBinding(bindingFake.getUniqueName(), null);
        WildcardAddressManagerUnitTest.assertNull((Object)ad.getExistingBindingsForRoutingAddress(address));
    }

    @Test(expected=ActiveMQQueueExistsException.class)
    public void testWildCardAddAlreadyExistingBindingShouldThrowException() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Queue1.#"), RoutingType.ANYCAST));
        ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
        ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
    }

    @Test
    public void testWildCardAddressRemovalDifferentWildcard() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.test"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.>", "one"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.>")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.test")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.test")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.>")).size());
        ad.removeAddressInfo(SimpleString.toSimpleString((String)"Topic1.test"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getAddresses().size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindings().count());
        ad.removeBinding(SimpleString.toSimpleString((String)"one"), null);
        ad.removeAddressInfo(SimpleString.toSimpleString((String)"Topic1.>"));
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getAddresses().size());
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getBindings().count());
    }

    @Test
    public void testWildCardAddressDirectBindings() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.test"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.test.test1"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic1.test.test2"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic2.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"Topic2.test"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.>", "one"));
        ad.addBinding((Binding)new BindingFake("Topic1.test", "two"));
        ad.addBinding((Binding)new BindingFake("Topic2.test", "three"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.>")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)2L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.test")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.test.test1")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"Topic1.test.test2")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.>")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.test")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.test1")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic1.test2")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)0L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic2.>")).size());
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getDirectBindings(SimpleString.toSimpleString((String)"Topic2.test")).size());
    }

    @Test
    public void testNumberOfBindingsThatMatch() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addBinding((Binding)new BindingFake("T.>", "1"));
        ad.addBinding((Binding)new BindingFake("T.>", "2"));
        ad.addBinding((Binding)new BindingFake("T.>", "3"));
        WildcardAddressManagerUnitTest.assertEquals((long)3L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)3L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.2")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)3L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.3")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)3L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.>")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.*", "10"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.*")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)3L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.>")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)4L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)4L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.2")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)4L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.3")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.>", "11"));
        WildcardAddressManagerUnitTest.assertEquals((long)1L, (long)ad.getExistingBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1.>")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)5L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)4L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.2")).getBindings().size());
        WildcardAddressManagerUnitTest.assertEquals((long)4L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.3")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.2", "12"));
        WildcardAddressManagerUnitTest.assertEquals((long)5L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1.2")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.2.3.4", "13"));
        WildcardAddressManagerUnitTest.assertEquals((long)5L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1.2.3.4")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.>.4", "14"));
        WildcardAddressManagerUnitTest.assertEquals((long)6L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1.2.3.4")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.A.3.4", "15"));
        WildcardAddressManagerUnitTest.assertEquals((long)6L, (long)ad.getBindingsForRoutingAddress(SimpleString.toSimpleString((String)"T.1.A.3.4")).getBindings().size());
    }

    @Test
    public void testConcurrentCalls() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        SimpleString wildCard = SimpleString.toSimpleString((String)"Topic1.>");
        ad.addAddressInfo(new AddressInfo(wildCard, RoutingType.MULTICAST));
        AtomicReference oops = new AtomicReference();
        int numSubs = 500;
        int numThreads = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        int i = 0;
        while (i < numSubs) {
            int id = i++;
            executorService.submit(() -> {
                try {
                    ExecutorService executorService2 = executorService;
                    synchronized (executorService2) {
                        ad.addBinding((Binding)new BindingFake(SimpleString.toSimpleString((String)"Topic1.>"), SimpleString.toSimpleString((String)("" + id))));
                    }
                    SimpleString pubAddr = SimpleString.toSimpleString((String)("Topic1." + id));
                    ad.getBindingsForRoutingAddress(pubAddr);
                    ad.getBindingsForRoutingAddress(pubAddr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    oops.set(e);
                }
            });
        }
        executorService.shutdown();
        WildcardAddressManagerUnitTest.assertTrue((String)"finished on time", (boolean)executorService.awaitTermination(10L, TimeUnit.MINUTES));
        WildcardAddressManagerUnitTest.assertNull((String)"no exceptions", oops.get());
    }

    static class BindingsFake
    implements Bindings {
        SimpleString name;
        ConcurrentHashMap<SimpleString, Binding> bindings = new ConcurrentHashMap();

        BindingsFake(SimpleString address) {
            this.name = address;
        }

        public Collection<Binding> getBindings() {
            return this.bindings.values();
        }

        public void addBinding(Binding binding) {
            this.bindings.put(binding.getUniqueName(), binding);
        }

        public Binding removeBindingByUniqueName(SimpleString uniqueName) {
            return this.bindings.remove(uniqueName);
        }

        public SimpleString getName() {
            return this.name;
        }

        public void setMessageLoadBalancingType(MessageLoadBalancingType messageLoadBalancingType) {
        }

        public MessageLoadBalancingType getMessageLoadBalancingType() {
            return null;
        }

        public void unproposed(SimpleString groupID) {
        }

        public void updated(QueueBinding binding) {
        }

        public boolean redistribute(Message message, Queue originatingQueue, RoutingContext context) throws Exception {
            return false;
        }

        public void route(Message message, RoutingContext context) throws Exception {
            log.debug((Object)("routing message: " + message));
        }

        public boolean allowRedistribute() {
            return false;
        }
    }

    static class BindingFake
    implements Binding {
        final SimpleString address;
        final SimpleString id;

        BindingFake(String addressParameter, String id) {
            this(SimpleString.toSimpleString((String)addressParameter), SimpleString.toSimpleString((String)id));
        }

        BindingFake(SimpleString addressParameter, SimpleString id) {
            this.address = addressParameter;
            this.id = id;
        }

        public void unproposed(SimpleString groupID) {
        }

        public SimpleString getAddress() {
            return this.address;
        }

        public Bindable getBindable() {
            return null;
        }

        public BindingType getType() {
            return null;
        }

        public SimpleString getUniqueName() {
            return this.id;
        }

        public SimpleString getRoutingName() {
            return null;
        }

        public SimpleString getClusterName() {
            return null;
        }

        public Filter getFilter() {
            return null;
        }

        public boolean isHighAcceptPriority(Message message) {
            return false;
        }

        public boolean isExclusive() {
            return false;
        }

        public Long getID() {
            return 0L;
        }

        public int getDistance() {
            return 0;
        }

        public void route(Message message, RoutingContext context) throws Exception {
        }

        public void close() throws Exception {
        }

        public String toManagementString() {
            return "FakeBiding Address=" + this.address;
        }

        public boolean isConnected() {
            return true;
        }

        public void routeWithAck(Message message, RoutingContext context) {
        }
    }

    static class BindingFactoryFake
    implements BindingsFactory {
        BindingFactoryFake() {
        }

        public Bindings createBindings(SimpleString address) {
            return new BindingsFake(address);
        }
    }
}

