/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.misc;

import java.io.File;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionMetaData;
import org.apache.activemq.artemis.tests.unit.UnitTestLogger;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ManifestTest
extends ActiveMQTestBase {
    @Test
    public void testManifestEntries() throws Exception {
        Properties props = System.getProperties();
        String userDir = props.getProperty("build.lib");
        UnitTestLogger.LOGGER.trace("userDir is " + userDir);
        File file = new File("build/jars", "activemq-core.jar");
        Assert.assertTrue((boolean)file.exists());
        JarFile jar = new JarFile(file);
        Manifest manifest = jar.getManifest();
        ActiveMQServer server = ActiveMQServers.newActiveMQServer((Configuration)this.createBasicConfig());
        ActiveMQConnectionMetaData meta = new ActiveMQConnectionMetaData(server.getVersion());
        Attributes attrs = manifest.getMainAttributes();
        Assert.assertEquals((Object)meta.getProviderVersion(), (Object)attrs.getValue("ActiveMQ-Version"));
    }
}

