/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.i18n;

import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.util.NoSuchElementException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRMSG", length=5)
public interface KafkaExceptions {
    public static final KafkaExceptions ex = (KafkaExceptions)Messages.getBundle(KafkaExceptions.class);

    @Message(id=18000, value="`message` does not contain metadata of class %s")
    public IllegalArgumentException illegalArgumentNoMetadata(Class var1);

    @Message(id=18001, value="Unknown failure strategy: %s")
    public IllegalArgumentException illegalArgumentUnknownFailureStrategy(String var1);

    @Message(id=18002, value="Expecting downstream to consume without back-pressure")
    public IllegalStateException illegalStateConsumeWithoutBackPressure();

    @Message(id=18003, value="Only one subscriber allowed")
    public IllegalStateException illegalStateOnlyOneSubscriber();

    @Message(id=18004, value="Invalid failure strategy: %s")
    public IllegalArgumentException illegalArgumentInvalidFailureStrategy(String var1);

    @Message(id=18005, value="Unknown commit strategy: %s")
    public IllegalArgumentException illegalArgumentUnknownCommitStrategy(String var1);

    @Message(id=18006, value="Invalid commit strategy: %s")
    public IllegalArgumentException illegalArgumentInvalidCommitStrategy(String var1);

    @Message(id=18007, value="Unable to find the KafkaConsumerRebalanceListener named `%s` for channel `%s`")
    public UnsatisfiedResolutionException unableToFindRebalanceListener(String var1, String var2);

    @Message(id=18008, value="Unable to select the KafkaConsumerRebalanceListener named `%s` for channel `%s` - too many matches (%d)")
    public AmbiguousResolutionException unableToFindRebalanceListener(String var1, String var2, int var3);

    @Message(id=18009, value="Cannot configure the Kafka consumer for channel `%s` - the `mp.messaging.incoming.%s.value.deserializer` property is missing")
    public IllegalArgumentException missingValueDeserializer(String var1, String var2);

    @Message(id=18010, value="Unable to create an instance of `%s`")
    public IllegalArgumentException unableToCreateInstance(String var1, @Cause Throwable var2);

    @Message(id=18011, value="Unable to find the DeserializationFailureHandler named `%s` for channel `%s`")
    public UnsatisfiedResolutionException unableToFindDeserializationFailureHandler(String var1, String var2);

    @Message(id=18012, value="Unable to select the DeserializationFailureHandler named `%s` for channel `%s` - too many matches (%d)")
    public AmbiguousResolutionException unableToFindDeserializationFailureHandler(String var1, String var2, int var3);

    @Message(id=18013, value="Cannot configure the Kafka producer for channel `%s` - the `mp.messaging.outgoing.%s.value.serializer` property is missing")
    public IllegalArgumentException missingValueSerializer(String var1, String var2);

    @Message(id=18014, value="The config property '%s' is required but it could not be found in any config source")
    public NoSuchElementException missingProperty(String var1);

    @Message(id=18015, value="Cannot convert property '%s' of type %s to %s")
    public NoSuchElementException cannotConvertProperty(String var1, Class<?> var2, Class<?> var3);
}

