/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.service.ServiceRegistry;

public abstract class AbstractCompositeIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    protected final Class compositeIdClass;
    protected Map<PropertyData, SingleIdMapper> ids;

    protected AbstractCompositeIdMapper(Class compositeIdClass, ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        this.compositeIdClass = compositeIdClass;
        this.ids = Tools.newLinkedHashMap();
    }

    @Override
    public void add(PropertyData propertyData) {
        this.ids.put(propertyData, new SingleIdMapper(this.getServiceRegistry(), propertyData));
    }

    @Override
    public Object mapToIdFromMap(Map data) {
        if (data == null) {
            return null;
        }
        Object compositeId = this.instantiateCompositeId();
        for (SingleIdMapper mapper : this.ids.values()) {
            if (mapper.mapToEntityFromMap(compositeId, data)) continue;
            return null;
        }
        return compositeId;
    }

    protected Object instantiateCompositeId() {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return ReflectHelper.getDefaultConstructor((Class)AbstractCompositeIdMapper.this.compositeIdClass).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new AuditException(e);
                }
            }
        });
    }
}

