/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import java.io.InputStream;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.util.NoContentInputStreamDelegate;

public class NoContent {
    public static InputStream noContentCheck(MultivaluedMap<String, String> httpHeaders, InputStream is) throws NoContentException {
        NoContent.contentLengthCheck(httpHeaders);
        NoContentInputStreamDelegate delegate = new NoContentInputStreamDelegate(is);
        return delegate;
    }

    public static boolean isContentLengthZero(MultivaluedMap<String, String> httpHeaders) {
        long length;
        if (httpHeaders == null) {
            return false;
        }
        String contentLength = (String)httpHeaders.getFirst((Object)"Content-Length");
        return contentLength != null && (length = Long.parseLong(contentLength)) == 0L;
    }

    public static void contentLengthCheck(MultivaluedMap<String, String> httpHeaders) throws NoContentException {
        if (NoContent.isContentLengthZero(httpHeaders)) {
            throw new NoContentException(Messages.MESSAGES.noContentContentLength0());
        }
    }
}

