/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.as.clustering.context.Contextualizer;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.Response;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherContext;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.ViewMembership;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.Functions;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory,
RequestHandler,
org.wildfly.clustering.spi.group.Group<Address>,
MembershipListener,
Runnable,
Function<GroupListener, ExecutorService> {
    static final Optional<Object> NO_SUCH_SERVICE = Optional.of(NoSuchService.INSTANCE);
    static final ExceptionSupplier<Object, Exception> NO_SUCH_SERVICE_SUPPLIER = Functions.constantExceptionSupplier((Object)((Object)NoSuchService.INSTANCE));
    private final ConcurrentMap<Address, Node> members = new ConcurrentHashMap<Address, Node>();
    private final Map<Object, CommandDispatcherContext<?, ?>> contexts = new ConcurrentHashMap();
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(this.getClass()));
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final AtomicReference<View> view = new AtomicReference();
    private final ByteBufferMarshaller marshaller;
    private final MessageDispatcher dispatcher;
    private final Duration timeout;
    private final Function<ClassLoader, ByteBufferMarshaller> marshallerFactory;
    private final Function<ClassLoader, Contextualizer> contextualizerFactory;

    public ChannelCommandDispatcherFactory(ChannelCommandDispatcherFactoryConfiguration config) {
        this.marshaller = config.getMarshaller();
        this.timeout = config.getTimeout();
        this.marshallerFactory = config.getMarshallerFactory();
        this.contextualizerFactory = config.getContextualizerFactory();
        JChannel channel = config.getChannel();
        RequestCorrelator correlator = new RequestCorrelator((Protocol)channel.getProtocolStack(), (RequestHandler)this, channel.getAddress()).setMarshaller((Marshaller)new CommandResponseMarshaller(config));
        this.dispatcher = new MessageDispatcher().setChannel(channel).setRequestHandler((RequestHandler)this).setMembershipListener((MembershipListener)this).asyncDispatching(true).correlator(correlator);
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public void run() {
        this.shutdown(this.executorService);
        this.dispatcher.stop();
        this.dispatcher.getChannel().setUpHandler(null);
        for (ExecutorService executor : this.listeners.values()) {
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    @Override
    public void close() {
        this.executor.close((Runnable)this);
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Object handle(Message request) throws Exception {
        return this.read(request).get();
    }

    public void handle(Message request, final Response response) throws Exception {
        final ExceptionSupplier<Object, Exception> commandTask = this.read(request);
        Runnable responseTask = new Runnable(){

            @Override
            public void run() {
                try {
                    response.send(commandTask.get(), false);
                }
                catch (Throwable e) {
                    response.send((Object)e, true);
                }
            }
        };
        try {
            this.executorService.submit(responseTask);
        }
        catch (RejectedExecutionException e) {
            response.send((Object)NoSuchService.INSTANCE, false);
        }
    }

    private ExceptionSupplier<Object, Exception> read(Message message) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(message.getRawBuffer(), message.getOffset(), message.getLength());
        Map.Entry entry = (Map.Entry)this.marshaller.read(buffer);
        Object clientId = entry.getKey();
        final CommandDispatcherContext<?, ?> context = this.contexts.get(clientId);
        if (context == null) {
            return NO_SUCH_SERVICE_SUPPLIER;
        }
        final Object commandContext = context.getCommandContext();
        final Contextualizer contextualizer = context.getContextualizer();
        MarshalledValue value = (MarshalledValue)entry.getValue();
        final Command command = (Command)value.get(context.getMarshalledValueFactory().getMarshallingContext());
        ExceptionSupplier<Object, Exception> commandExecutionTask = new ExceptionSupplier<Object, Exception>(){

            public Object get() throws Exception {
                return context.getMarshalledValueFactory().createMarshalledValue(command.execute(commandContext));
            }
        };
        final ServiceExecutor executor = this.executor;
        return new ExceptionSupplier<Object, Exception>((ExceptionSupplier)commandExecutionTask){
            final /* synthetic */ ExceptionSupplier val$commandExecutionTask;
            {
                this.val$commandExecutionTask = exceptionSupplier;
            }

            public Object get() throws Exception {
                return executor.execute(contextualizer.contextualize(this.val$commandExecutionTask)).orElse(NO_SUCH_SERVICE);
            }
        };
    }

    public Group getGroup() {
        return this;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, final C commandContext, ClassLoader loader) {
        ByteBufferMarshaller dispatcherMarshaller = this.marshallerFactory.apply(loader);
        ByteBufferMarshalledValueFactory factory = new ByteBufferMarshalledValueFactory(dispatcherMarshaller);
        final Contextualizer contextualizer = this.contextualizerFactory.apply(loader);
        CommandDispatcherContext context = new CommandDispatcherContext<C, ByteBufferMarshaller>((MarshalledValueFactory)factory){
            final /* synthetic */ MarshalledValueFactory val$factory;
            {
                this.val$factory = marshalledValueFactory;
            }

            @Override
            public C getCommandContext() {
                return commandContext;
            }

            @Override
            public Contextualizer getContextualizer() {
                return contextualizer;
            }

            @Override
            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$factory;
            }
        };
        if (this.contexts.putIfAbsent(id, context) != null) {
            throw ClusteringServerLogger.ROOT_LOGGER.commandDispatcherAlreadyExists(id);
        }
        CommandDispatcherMarshaller marshaller = new CommandDispatcherMarshaller(this.marshaller, id, factory);
        LocalCommandDispatcher localDispatcher = new LocalCommandDispatcher(this.getLocalMember(), commandContext);
        return new ChannelCommandDispatcher<C, ByteBufferMarshaller>(this.dispatcher, marshaller, dispatcherMarshaller, this, this.timeout, localDispatcher, () -> {
            localDispatcher.close();
            this.contexts.remove(id);
        });
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(GroupListener listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    public String getName() {
        return this.dispatcher.getChannel().getClusterName();
    }

    public Membership getMembership() {
        return new ViewMembership(this.dispatcher.getChannel().getAddress(), this.view.get(), (NodeFactory<Address>)this);
    }

    public Node getLocalMember() {
        return this.createNode(this.dispatcher.getChannel().getAddress());
    }

    public boolean isSingleton() {
        return false;
    }

    public Node createNode(Address address) {
        return this.members.computeIfAbsent(address, key -> {
            IpAddress ipAddress = (IpAddress)this.dispatcher.getChannel().down(new Event(87, (Object)address));
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            String name = Optional.ofNullable(NameCache.get((Address)address)).orElseGet(() -> String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort()));
            return new AddressableNode(address, name, socketAddress);
        });
    }

    public Address getAddress(Node node) {
        return ((AddressableNode)node).getAddress();
    }

    public void viewAccepted(final View view) {
        View oldView = this.view.getAndSet(view);
        if (oldView != null) {
            List leftMembers = View.leftMembers((View)oldView, (View)view);
            if (leftMembers != null) {
                this.members.keySet().removeAll(leftMembers);
            }
            if (!this.listeners.isEmpty()) {
                Address localAddress = this.dispatcher.getChannel().getAddress();
                final ViewMembership oldMembership = new ViewMembership(localAddress, oldView, (NodeFactory<Address>)this);
                final ViewMembership membership = new ViewMembership(localAddress, view, (NodeFactory<Address>)this);
                for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                    final GroupListener listener = entry.getKey();
                    ExecutorService executor = entry.getValue();
                    Runnable listenerTask = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.membershipChanged((Membership)oldMembership, (Membership)membership, view instanceof MergeView);
                            }
                            catch (Throwable e) {
                                ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), e);
                            }
                        }
                    };
                    try {
                        executor.submit(listenerTask);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
            }
        }
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }
}

