/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class CustomExecuteJava
implements TimeoutObserver {
    private CommandlineJava command = null;
    private Long timeout = null;
    private volatile boolean timedOut = false;
    private Thread thread = null;

    public void setCommandlineJava(CommandlineJava command) {
        this.command = command;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public synchronized void timeoutOccured(Watchdog w) {
        if (this.thread != null) {
            this.timedOut = true;
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public synchronized boolean killedProcess() {
        return this.timedOut;
    }

    public int fork(ProjectComponent pc) throws BuildException {
        Redirector redirector = new Redirector(pc);
        Execute exe = new Execute(redirector.createHandler(), this.timeout == null ? null : new ExecuteWatchdog(this.timeout.longValue()));
        exe.setAntRun(pc.getProject());
        String[] cl = this.command.getCommandline();
        for (int i = 0; i < cl.length; ++i) {
            if (!cl[i].endsWith("\n")) continue;
            cl[i] = cl[i].substring(0, cl[i].length() - 1);
        }
        if (Os.isFamily((String)"openvms")) {
            ExecuteJava.setupCommandLineForVMS((Execute)exe, (String[])cl);
        } else {
            exe.setCommandline(cl);
        }
        try {
            int rc = exe.execute();
            redirector.complete();
            int n = rc;
            return n;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.timedOut = exe.killedProcess();
        }
    }
}

