/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.security;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.soap.client.security.SOAPClientSecurityContext;

public class SOAPClientSecurityProfileIdLookupFunction
implements ContextDataLookupFunction<MessageContext, String> {
    private Function<MessageContext, SOAPClientSecurityContext> soapContextLookup = Functions.compose((Function)new ChildContextLookup(SOAPClientSecurityContext.class), (Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));

    public void setSOAPClientSecurityContextLookup(@Nonnull Function<MessageContext, SOAPClientSecurityContext> lookup) {
        this.soapContextLookup = (Function)Constraint.isNotNull(lookup, (String)"SOAPClientSecurityContext lookup function was null");
    }

    public String apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        SOAPClientSecurityContext context = (SOAPClientSecurityContext)((Object)this.soapContextLookup.apply((Object)messageContext));
        if (context != null) {
            return context.getSecurityConfigurationProfileId();
        }
        return null;
    }
}

