/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.Util;

public class DatabaseCertLoginModule
extends BaseCertLoginModule {
    private static final String DS_JNDI_NAME = "dsJndiName";
    private static final String ROLES_QUERY = "rolesQuery";
    private static final String SUSPEND_RESUME = "suspendResume";
    private static final String TRANSACTION_MANAGER_JNDI_NAME = "transactionManagerJndiName";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"dsJndiName", "rolesQuery", "suspendResume"};
    private String dsJndiName;
    protected String txManagerJndiName = "java:/TransactionManager";
    private String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";
    protected boolean suspendResume = true;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Object tmp;
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get(DS_JNDI_NAME);
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get(ROLES_QUERY)) != null) {
            this.rolesQuery = tmp.toString();
        }
        if ((tmp = options.get(SUSPEND_RESUME)) != null) {
            this.suspendResume = Boolean.valueOf(tmp.toString());
        }
        if ((tmp = options.get(TRANSACTION_MANAGER_JNDI_NAME)) != null) {
            this.txManagerJndiName = tmp.toString();
        }
        PicketBoxLogger.LOGGER.traceDBCertLoginModuleOptions(this.dsJndiName, "", this.rolesQuery, this.suspendResume);
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.txManagerJndiName, this.rolesQuery, this, this.suspendResume);
        return roleSets;
    }
}

