/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSDurableConsumerTest
extends JMSClientTestSupport {
    @Parameterized.Parameter(value=0)
    public boolean amqpUseCoreSubscriptionNaming;

    @Parameterized.Parameters(name="{index}: amqpUseCoreSubscriptionNaming={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setAmqpUseCoreSubscriptionNaming(this.amqpUseCoreSubscriptionNaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerAsync() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference received = new AtomicReference();
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    received.set(message);
                    latch.countDown();
                }
            });
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            JMSDurableConsumerTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            JMSDurableConsumerTest.assertNotNull((String)"Should have received a message by now.", received.get());
            JMSDurableConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received.get() instanceof TextMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerSync() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            final AtomicReference msg = new AtomicReference();
            JMSDurableConsumerTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition((MessageConsumer)consumer){
                final /* synthetic */ MessageConsumer val$consumer;
                {
                    this.val$consumer = messageConsumer;
                }

                public boolean isSatisfied() throws Exception {
                    msg.set(this.val$consumer.receiveNoWait());
                    return msg.get() != null;
                }
            }, (long)TimeUnit.SECONDS.toMillis(25L), (long)TimeUnit.MILLISECONDS.toMillis(200L)));
            JMSDurableConsumerTest.assertNotNull((String)"Should have received a message by now.", msg.get());
            JMSDurableConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(msg.get() instanceof TextMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerUnsubscribe() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            JMSDurableConsumerTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisfied() throws Exception {
                    return JMSDurableConsumerTest.this.server.getTotalConsumerCount() == 1L;
                }
            }, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            consumer.close();
            JMSDurableConsumerTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisfied() throws Exception {
                    return JMSDurableConsumerTest.this.server.getTotalConsumerCount() == 0L;
                }
            }, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            session.unsubscribe("DurbaleTopic");
            JMSDurableConsumerTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisfied() throws Exception {
                    return JMSDurableConsumerTest.this.server.getTotalConsumerCount() == 0L;
                }
            }, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerUnsubscribeWhileNoSubscription() throws Exception {
        try (Connection connection = this.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            JMSDurableConsumerTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisfied() throws Exception {
                    return JMSDurableConsumerTest.this.server.getTotalConsumerCount() == 0L;
                }
            }, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            try {
                session.unsubscribe("DurbaleTopic");
                JMSDurableConsumerTest.fail((String)"Should have thrown as subscription is in use.");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerUnsubscribeWhileActive() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            JMSDurableConsumerTest.assertNotNull((Object)consumer);
            JMSDurableConsumerTest.assertNull((Object)consumer.receive(10L));
            try {
                session.unsubscribe("DurbaleTopic");
                JMSDurableConsumerTest.fail((String)"Should have thrown as subscription is in use.");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDurableConsumerLarge() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer1 = session.createDurableSubscriber(topic, "DurbaleSub1");
            TopicSubscriber consumer2 = session.createDurableSubscriber(topic, "DurbaleSub2");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            ObjectMessage objMessage = session.createObjectMessage();
            BigObject bigObject = new BigObject(102400);
            objMessage.setObject((Serializable)bigObject);
            producer.send((Message)objMessage);
            ObjectMessage msg1 = (ObjectMessage)consumer1.receive(5000L);
            Assert.assertNotNull((Object)msg1);
            JMSDurableConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(msg1 instanceof ObjectMessage));
            ObjectMessage msg2 = (ObjectMessage)consumer2.receive(5000L);
            JMSDurableConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)msg2);
            JMSDurableConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(msg2 instanceof ObjectMessage));
        }
    }

    public static class BigObject
    implements Serializable {
        private char[] contents;

        public BigObject(int size) {
            this.contents = new char[size];
            for (int i = 0; i < size; ++i) {
                this.contents[i] = 88;
            }
        }
    }
}

